/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.graph;

import gnutellasim.graph.DownloadEdge;
import gnutellasim.graph.GnutellaEdge;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.simulation.Simulation;
import gnutellasim.statistics.GlobalStatisticCollector;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.Port;

public class GnutellaGraph
extends DefaultGraphModel {
    private static GnutellaGraph singleton;
    private Hashtable attrs = new Hashtable();

    private GnutellaGraph() {
        GlobalStatisticCollector[] gscs = Simulation.getGlobalStaticCollectors();
        int i = 0;
        while (i < gscs.length) {
            gscs[i].init(this, Simulation.getCycle());
            ++i;
        }
    }

    public static GnutellaGraph getGraph() {
        if (singleton == null) {
            singleton = new GnutellaGraph();
        }
        return singleton;
    }

    public void addNode(GnutellaNode n) {
        Hashtable<GnutellaNode, AttributeMap> attributes = new Hashtable<GnutellaNode, AttributeMap>();
        GnutellaNode node = n;
        AttributeMap attr = new AttributeMap();
        attributes.put(node, attr);
        Rectangle bounds = new Rectangle(n.getX(), n.getY(), 30, 30);
        GraphConstants.setBounds(attr, bounds);
        GraphConstants.setBorderColor(attr, Color.black);
        DefaultPort port = new DefaultPort();
        node.add(port);
        Object[] cells = new Object[]{node};
        this.insert(cells, attributes, null, null, null);
    }

    public void removeNode(GnutellaNode n) {
        GnutellaNode[] nei = n.getNeighbors();
        int i = 0;
        while (i < nei.length) {
            this.removeEdge(this.edgeConnecting(n, nei[i]));
            ++i;
        }
        DownloadEdge[] down = n.getDownloadEdges();
        int i2 = 0;
        while (i2 < down.length) {
            this.removeEdge(down[i2]);
            ++i2;
        }
        n.setDeath(true);
    }

    public GnutellaNode[] getNodes() {
        Vector<Object> nodes = new Vector<Object>();
        int i = 0;
        while (i < this.getRootCount()) {
            Object root = this.getRootAt(i);
            if (root instanceof GnutellaNode) {
                nodes.add(root);
            }
            ++i;
        }
        return nodes.toArray(new GnutellaNode[nodes.size()]);
    }

    public void addEdge(GnutellaEdge e, GnutellaNode n1, GnutellaNode n2) {
        e.setNode1(n1);
        e.setNode2(n2);
        ConnectionSet cs = new ConnectionSet((Edge)e, this.getPort(n1), this.getPort(n2));
        Object[] insert = new Object[]{e};
        this.insert(insert, null, cs, null, null);
    }

    public void removeEdge(GnutellaEdge e) {
        this.remove(DefaultGraphModel.getDescendantList(this, new Object[]{e}).toArray());
    }

    public boolean hasEdge(GnutellaEdge e) {
        int i = 0;
        while (i < this.getRootCount()) {
            Object root = this.getRootAt(i);
            if (root == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasNode(GnutellaNode n) {
        int i = 0;
        while (i < this.getRootCount()) {
            Object root = this.getRootAt(i);
            if (root == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RoutingEdge edgeConnecting(GnutellaNode n1, GnutellaNode n2) {
        int i = 0;
        while (i < this.getRootCount()) {
            Object root = this.getRootAt(i);
            if (root instanceof RoutingEdge && (((RoutingEdge)root).getNode1() == n1 && ((RoutingEdge)root).getNode2() == n2 || ((RoutingEdge)root).getNode1() == n2 && ((RoutingEdge)root).getNode2() == n1)) {
                return (RoutingEdge)root;
            }
            ++i;
        }
        return null;
    }

    private Port getPort(GnutellaNode n) {
        int i = 0;
        while (i < this.getChildCount(n)) {
            Object child = this.getChild(n, i);
            if (child instanceof Port) {
                return (Port)child;
            }
            ++i;
        }
        return null;
    }

    public void setAttribut(String key, Object attr) {
        this.attrs.put(key, attr);
    }

    public Object getAttribut(String key) {
        return this.attrs.get(key);
    }
}

