/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.graph;

import gnutellasim.graph.DownloadEdge;
import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.protocols.Protocol;
import gnutellasim.simulation.Simulation;
import gnutellasim.statistics.NodeStatisticCollector;
import gnutellasim.util.BoundedMessageBuffer;
import gnutellasim.util.DefaultValues;
import gnutellasim.util.IdNumberFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Port;

public class GnutellaNode
extends DefaultGraphCell {
    private Vector changeListeners = new Vector();
    private BoundedMessageBuffer bmb;
    private Hashtable attributHT;
    private int id = IdNumberFactory.getLastId();
    private int x;
    private int y;
    private boolean active;
    private boolean death;

    public GnutellaNode(int x, int y) {
        super(String.valueOf(IdNumberFactory.getId()));
        this.attributHT = new Hashtable();
        this.x = x;
        this.y = y;
        this.active = DefaultValues.getActive();
        this.bmb = new BoundedMessageBuffer(DefaultValues.getNodeBufferSize());
        this.death = false;
        Protocol[] protocols = Simulation.getProtocols();
        int i = 0;
        while (i < protocols.length) {
            protocols[i].init(this, Simulation.getCycle());
            ++i;
        }
        NodeStatisticCollector[] nsc = Simulation.getNodeStatisticCollectors();
        int i2 = 0;
        while (i2 < nsc.length) {
            nsc[i2].init(this, Simulation.getCycle());
            ++i2;
        }
    }

    public GnutellaNode(int x, int y, boolean active) {
        this(x, y);
        this.active = active;
    }

    public GnutellaNode() {
        this(0, 0);
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void addNeighbor(GnutellaNode n) {
        if (!this.graph().hasNode(n)) {
            this.graph().addNode(n);
        }
        RoutingEdge re = new RoutingEdge();
        this.graph().addEdge(re, this, n);
    }

    public void removeNeighbor(GnutellaNode n) {
        RoutingEdge e = this.graph().edgeConnecting(n, this);
        if (e != null) {
            this.graph().removeEdge(e);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.setUserObject(String.valueOf(id));
    }

    public boolean hasNeighbor(GnutellaNode n) {
        GnutellaNode[] gn = this.getNeighbors();
        int i = 0;
        while (i < gn.length) {
            if (gn[i] == n) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int neighborCount() {
        return this.getNeighbors().length;
    }

    public String toString() {
        return "Node " + this.getId();
    }

    public GnutellaNode[] getNeighbors() {
        Port portOfThis = this.getPort();
        Iterator itr = portOfThis.edges();
        ArrayList<GnutellaNode> ar = new ArrayList<GnutellaNode>();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof RoutingEdge)) continue;
            RoutingEdge edge = (RoutingEdge)o;
            if (edge.getNode1() == this) {
                ar.add(edge.getNode2());
                continue;
            }
            if (edge.getNode2() != this) continue;
            ar.add(edge.getNode1());
        }
        return ar.toArray(new GnutellaNode[ar.size()]);
    }

    public DownloadEdge[] getDownloadEdges() {
        Port portOfThis = this.getPort();
        Iterator itr = portOfThis.edges();
        ArrayList<DownloadEdge> ar = new ArrayList<DownloadEdge>();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof DownloadEdge)) continue;
            DownloadEdge edge = (DownloadEdge)o;
            if (edge.getNode1() == this) {
                ar.add(edge);
                continue;
            }
            if (edge.getNode2() != this) continue;
            ar.add(edge);
        }
        return ar.toArray(new DownloadEdge[ar.size()]);
    }

    public Object getAttribut(String s) {
        return this.attributHT.get(s);
    }

    public void setAttribut(String s, Object o) {
        this.attributHT.put(s, o);
        int i = 0;
        while (i < this.changeListeners.size()) {
            if (((String)this.changeListeners.get(i)).equals(s)) {
                ChangeListener l = (ChangeListener)this.changeListeners.get(i + 1);
                l.stateChanged(new ChangeEvent(o));
            }
            i += 2;
        }
    }

    public void addAttributChangedListener(ChangeListener listener, String attribut) {
        this.changeListeners.add(attribut);
        this.changeListeners.add(listener);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public BoundedMessageBuffer getMessageBuffer() {
        return this.bmb;
    }

    private GnutellaGraph graph() {
        return GnutellaGraph.getGraph();
    }

    public Port getPort() {
        int i = 0;
        while (i < this.graph().getChildCount(this)) {
            Object child = this.graph().getChild(this, i);
            if (child instanceof Port) {
                return (Port)child;
            }
            ++i;
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public void setDeath(boolean b) {
        this.death = b;
    }

    public boolean isDeath() {
        return this.death;
    }
}

