/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.gui;

import gnutellasim.graph.DownloadEdge;
import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.gui.GlobalStatisticAction;
import gnutellasim.gui.LanguageConstants;
import gnutellasim.gui.MyMarqueeHandler;
import gnutellasim.gui.RoutingEdgeStatisticAction;
import gnutellasim.gui.StatisticAction;
import gnutellasim.message.Network;
import gnutellasim.simulation.Simulation;
import gnutellasim.util.File;
import gnutellasim.view.GraphView;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.table.AbstractTableModel;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class GraphEditor
extends JPanel
implements GraphSelectionListener,
KeyListener {
    protected Simulation simulation;
    protected JGraph graph;
    protected GraphUndoManager undoManager;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action cut;
    protected Action copy;
    protected Action paste;
    protected Action play;
    protected Action pause;
    protected Action group;
    protected Action ungroup;
    protected Action tofront;
    protected Action toback;

    public GraphEditor(GraphModel m) {
        this.setLayout(new BorderLayout());
        this.graph = new GraphView(m);
        this.graph.setMarqueeHandler(new MyMarqueeHandler(this));
        this.undoManager = new GraphUndoManager(){

            public void undoableEditHappened(UndoableEditEvent e) {
                super.undoableEditHappened(e);
                GraphEditor.this.updateHistoryButtons();
            }
        };
        this.graph.getModel().addUndoableEditListener(this.undoManager);
        this.graph.getSelectionModel().addGraphSelectionListener(this);
        this.graph.addKeyListener(this);
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane(this.graph), "Center");
        this.add((Component)this.createProtocolBar(), "South");
    }

    private JPanel createProtocolBar() {
        JPanel res = new JPanel();
        res.setLayout(new FlowLayout());
        JPanel ping = new JPanel(){

            public void paint(Graphics g) {
                g.setColor(Color.RED);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        ping.setSize(150, 150);
        res.add(ping);
        res.add(new JLabel("PING"));
        JPanel pong = new JPanel(){

            public void paint(Graphics g) {
                g.setColor(Color.BLUE);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        pong.setSize(15, 15);
        res.add(pong);
        res.add(new JLabel("PONG"));
        JPanel query = new JPanel(){

            public void paint(Graphics g) {
                g.setColor(Color.GREEN);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        query.setSize(15, 15);
        res.add(query);
        res.add(new JLabel("QUERY"));
        JPanel queryhit = new JPanel(){

            public void paint(Graphics g) {
                g.setColor(Color.YELLOW);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        queryhit.setSize(15, 15);
        res.add(queryhit);
        res.add(new JLabel("QUERY HIT"));
        JPanel datapack = new JPanel(){

            public void paint(Graphics g) {
                g.setColor(Color.DARK_GRAY);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        datapack.setSize(15, 15);
        res.add(datapack);
        res.add(new JLabel("DATA PACKET"));
        JPanel routing = new JPanel(){

            public void paint(Graphics g) {
                g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            }
        };
        routing.setSize(5, 15);
        res.add(routing);
        res.add(new JLabel("ROUTING EDGE"));
        JPanel download = new JPanel(){

            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                int c = 0;
                int j = 0;
                float[] lineDash = new float[]{10.0f, 10.0f};
                g2.setStroke(new BasicStroke(5.0f, c, j, 10.0f, lineDash, 0.0f));
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            }
        };
        download.setSize(15, 15);
        res.add(download);
        res.add(new JLabel("DOWNLOAD EDGE"));
        return res;
    }

    public void insert(Point2D point) {
        ((GnutellaGraph)this.graph.getModel()).addNode(new GnutellaNode((int)Math.round(point.getX()), (int)Math.round(point.getY())));
    }

    public void connect(Port source, Port target) {
        GnutellaNode n1 = null;
        GnutellaGraph g = GnutellaGraph.getGraph();
        int i = 0;
        while (i < g.getRootCount()) {
            Object root = g.getRootAt(i);
            if (root instanceof GnutellaNode && ((GnutellaNode)root).getPort() != null && ((GnutellaNode)root).getPort() == source) {
                n1 = (GnutellaNode)root;
            }
            ++i;
        }
        GnutellaNode n2 = null;
        int i2 = 0;
        while (i2 < g.getRootCount()) {
            Object root = g.getRootAt(i2);
            if (root instanceof GnutellaNode && ((GnutellaNode)root).getPort() != null && ((GnutellaNode)root).getPort() == target) {
                n2 = (GnutellaNode)root;
            }
            ++i2;
        }
        ((GnutellaGraph)this.graph.getModel()).addEdge(new RoutingEdge(), n1, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void undo() {
        try {
            try {
                this.undoManager.undo(this.graph.getGraphLayoutCache());
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updateHistoryButtons();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updateHistoryButtons();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redo() {
        try {
            try {
                this.undoManager.redo(this.graph.getGraphLayoutCache());
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.updateHistoryButtons();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.updateHistoryButtons();
            return;
        }
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled = !this.graph.isSelectionEmpty();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.remove.actionPerformed(null);
        }
    }

    public JPopupMenu createPopupMenu(Point pt, final Object cell) {
        JPopupMenu menu = new JPopupMenu();
        if (cell != null) {
            menu.add(new AbstractAction(LanguageConstants.get("CHANGESETTINGS")){

                public void actionPerformed(ActionEvent e) {
                    if (cell instanceof GnutellaNode) {
                        this.editCell((GnutellaNode)cell);
                    } else if (cell instanceof RoutingEdge) {
                        this.editEdge((RoutingEdge)cell);
                    } else if (cell instanceof DownloadEdge) {
                        this.editDownloadEdge((DownloadEdge)cell);
                    }
                }

                private void editDownloadEdge(DownloadEdge edge) {
                    JPanel panel = new JPanel();
                    panel.setSize(450, 200);
                    JPanel buffer = new JPanel();
                    buffer.setSize(450, 20);
                    JLabel lable1 = new JLabel(LanguageConstants.get("DOWNLOADEDGECAPACITY"));
                    buffer.add((Component)lable1, "Center");
                    JLabel lable2 = new JLabel(String.valueOf(edge.getCapacity()));
                    JSlider slider1 = new JSlider(0, 1024, edge.getCapacity());
                    slider1.addChangeListener(new ChangeListener(this, edge, lable2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ DownloadEdge val$edge;
                        private final /* synthetic */ JLabel val$lable2;
                        {
                            this.this$1 = var1_1;
                            this.val$edge = downloadEdge;
                            this.val$lable2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            this.val$edge.setCapacity(((JSlider)arg0.getSource()).getValue());
                            this.val$lable2.setText(String.valueOf(((JSlider)arg0.getSource()).getValue()));
                            9.access$0(this.this$1).graph.repaint();
                        }
                    });
                    buffer.add(slider1);
                    buffer.add(lable2);
                    panel.add((Component)buffer, "Center");
                    JFrame frame = new JFrame(LanguageConstants.get("EDITEDGETITLE"));
                    frame.setSize(450, 200);
                    frame.getContentPane().add((Component)panel, "Center");
                    frame.show();
                }

                private void editEdge(RoutingEdge edge) {
                    JPanel panel = new JPanel();
                    panel.setSize(450, 200);
                    JPanel buffer = new JPanel();
                    buffer.setSize(450, 20);
                    JLabel lable1 = new JLabel(LanguageConstants.get("EDGECAPACITY"));
                    buffer.add((Component)lable1, "Center");
                    JLabel lable2 = new JLabel(String.valueOf(edge.getCapacity()));
                    JSlider slider1 = new JSlider(0, 100, edge.getCapacity());
                    slider1.addChangeListener(new ChangeListener(this, edge, lable2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ RoutingEdge val$edge;
                        private final /* synthetic */ JLabel val$lable2;
                        {
                            this.this$1 = var1_1;
                            this.val$edge = routingEdge;
                            this.val$lable2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            this.val$edge.setCapacity(((JSlider)arg0.getSource()).getValue());
                            this.val$lable2.setText(String.valueOf(((JSlider)arg0.getSource()).getValue()));
                            9.access$0(this.this$1).graph.repaint();
                        }
                    });
                    buffer.add(slider1);
                    buffer.add(lable2);
                    panel.add((Component)buffer, "Center");
                    JFrame frame = new JFrame(LanguageConstants.get("EDITEDGETITLE"));
                    frame.setSize(450, 200);
                    frame.getContentPane().add((Component)panel, "Center");
                    frame.show();
                }

                private void editCell(GnutellaNode node) {
                    JPanel panel = new JPanel();
                    panel.setSize(450, 200);
                    panel.setLayout(new FlowLayout());
                    JPanel nodeP = new JPanel();
                    nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("NODESETTINGS")));
                    nodeP.setLayout(new GridLayout(0, 1));
                    nodeP.setSize(450, 200);
                    JPanel buffer = new JPanel();
                    buffer.setLayout(new FlowLayout());
                    buffer.setSize(450, 20);
                    JLabel lable1 = new JLabel(LanguageConstants.get("MAXBUFFERSIZE"));
                    buffer.add(lable1);
                    JLabel lable2 = new JLabel(String.valueOf(node.getMessageBuffer().getBufferSize()));
                    JSlider slider1 = new JSlider(0, 1000, node.getMessageBuffer().getBufferSize());
                    slider1.addChangeListener(new ChangeListener(this, node, lable2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$lable2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$lable2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            this.val$node.getMessageBuffer().setBufferSize(((JSlider)arg0.getSource()).getValue());
                            this.val$lable2.setText(String.valueOf(((JSlider)arg0.getSource()).getValue()));
                        }
                    });
                    buffer.add(slider1);
                    buffer.add(lable2);
                    buffer.setAlignmentX(1.0f);
                    nodeP.add(buffer);
                    JPanel nroffiles = new JPanel();
                    nroffiles.setSize(450, 20);
                    JLabel nroffilesLabel1 = new JLabel(LanguageConstants.get("NUMBEROFFILES"));
                    nroffiles.add(nroffilesLabel1);
                    int nroffilesValue = (Integer)node.getAttribut("numberOfFiles");
                    JLabel nroffilesLabel2 = new JLabel(String.valueOf(nroffilesValue));
                    JSlider nroffilesSlider = new JSlider(0, 100, nroffilesValue);
                    nroffilesSlider.addChangeListener(new ChangeListener(this, node, nroffilesLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$nroffilesLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$nroffilesLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("numberOfFiles", new Integer(value));
                            this.val$nroffilesLabel2.setText(String.valueOf(value));
                            File[] oldfiles = (File[])this.val$node.getAttribut("ownedFiles");
                            File[] newfiles = new File[value];
                            if (oldfiles.length > newfiles.length) {
                                int i = 0;
                                while (i < newfiles.length) {
                                    newfiles[i] = oldfiles[i];
                                    ++i;
                                }
                            } else if (oldfiles.length < newfiles.length) {
                                int i = 0;
                                while (i < oldfiles.length) {
                                    newfiles[i] = oldfiles[i];
                                    ++i;
                                }
                                while (i < value) {
                                    newfiles[i] = File.getFile();
                                    ++i;
                                }
                            } else {
                                newfiles = oldfiles;
                            }
                            this.val$node.setAttribut("ownedFiles", newfiles);
                        }
                    });
                    nroffiles.add(nroffilesSlider);
                    nroffiles.add(nroffilesLabel2);
                    nodeP.add(nroffiles);
                    JPanel active = new JPanel();
                    active.setLayout(new FlowLayout());
                    active.setSize(450, 20);
                    JCheckBox check = new JCheckBox(LanguageConstants.get("ACTIVENODE"));
                    check.setSelected(node.isActive());
                    check.addChangeListener(new ChangeListener(this, node){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            this.val$node.setActive(((JCheckBox)arg0.getSource()).isSelected());
                            9.access$0(this.this$1).graph.repaint();
                        }
                    });
                    active.add(check);
                    nodeP.add(active);
                    panel.add(nodeP);
                    JPanel ping = new JPanel();
                    ping.setLayout(new GridLayout(0, 1));
                    ping.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("PINGPROTOCOLSETTINGS")));
                    int maxCount = (Integer)node.getAttribut("maxConnections");
                    JLabel maxConnectionCount = new JLabel(String.valueOf(maxCount));
                    JSlider maxConnectionSlider = new JSlider(0, 40, maxCount);
                    JPanel min = new JPanel();
                    min.setSize(450, 20);
                    JLabel minConnection = new JLabel(LanguageConstants.get("MINCONNECTIONS"));
                    min.add((Component)minConnection, "Center");
                    int minCount = (Integer)node.getAttribut("minConnections");
                    JLabel minConnectionCount = new JLabel(String.valueOf(minCount));
                    JSlider minConnectionSlider = new JSlider(0, 40, minCount);
                    minConnectionSlider.addChangeListener(new ChangeListener(this, node, minConnectionCount, maxConnectionSlider){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$minConnectionCount;
                        private final /* synthetic */ JSlider val$maxConnectionSlider;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$minConnectionCount = jLabel;
                            this.val$maxConnectionSlider = jSlider;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            JSlider source = (JSlider)arg0.getSource();
                            this.val$node.setAttribut("minConnections", new Integer(source.getValue()));
                            this.val$minConnectionCount.setText(String.valueOf(source.getValue()));
                            if (source.getValue() > this.val$maxConnectionSlider.getValue()) {
                                this.val$maxConnectionSlider.setValue(source.getValue());
                            }
                        }
                    });
                    min.add(minConnectionSlider);
                    min.add(minConnectionCount);
                    ping.add(min);
                    JPanel max = new JPanel();
                    max.setSize(450, 20);
                    JLabel maxConnection = new JLabel(LanguageConstants.get("MAXCONNECTIONS"));
                    max.add((Component)maxConnection, "Center");
                    maxConnectionSlider.addChangeListener(new ChangeListener(this, node, maxConnectionCount, minConnectionSlider){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$maxConnectionCount;
                        private final /* synthetic */ JSlider val$minConnectionSlider;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$maxConnectionCount = jLabel;
                            this.val$minConnectionSlider = jSlider;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            JSlider source = (JSlider)arg0.getSource();
                            this.val$node.setAttribut("maxConnections", new Integer(source.getValue()));
                            this.val$maxConnectionCount.setText(String.valueOf(source.getValue()));
                            if (source.getValue() < this.val$minConnectionSlider.getValue()) {
                                this.val$minConnectionSlider.setValue(source.getValue());
                            }
                        }
                    });
                    max.add(maxConnectionSlider);
                    max.add(maxConnectionCount);
                    ping.add(max);
                    JPanel pingFrq = new JPanel();
                    pingFrq.setSize(450, 20);
                    JLabel pingLabel1 = new JLabel(LanguageConstants.get("PINGFREQUENCY"));
                    pingFrq.add((Component)pingLabel1, "Center");
                    int pingFrqValue = (Integer)node.getAttribut("pingFrequency");
                    JLabel pingLabel2 = new JLabel(String.valueOf(pingFrqValue));
                    JSlider pingFrqSlider = new JSlider(0, 100, pingFrqValue);
                    pingFrqSlider.addChangeListener(new ChangeListener(this, node, pingLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$pingLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$pingLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("pingFrequency", new Integer(value));
                            this.val$pingLabel2.setText(String.valueOf(value));
                        }
                    });
                    pingFrq.add(pingFrqSlider);
                    pingFrq.add(pingLabel2);
                    ping.add(pingFrq);
                    JPanel pingttl = new JPanel();
                    pingttl.setSize(450, 20);
                    JLabel pingttlLabel1 = new JLabel(LanguageConstants.get("PINGTTL"));
                    pingttl.add((Component)pingttlLabel1, "Center");
                    int pingttlValue = (Integer)node.getAttribut("pingTtl");
                    JLabel pingttlLabel2 = new JLabel(String.valueOf(pingttlValue));
                    JSlider pingttlSlider = new JSlider(0, 20, pingttlValue);
                    pingttlSlider.addChangeListener(new ChangeListener(this, node, pingttlLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$pingttlLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$pingttlLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("pingTtl", new Integer(value));
                            this.val$pingttlLabel2.setText(String.valueOf(value));
                        }
                    });
                    pingttl.add(pingttlSlider);
                    pingttl.add(pingttlLabel2);
                    ping.add(pingttl);
                    panel.add(ping);
                    JPanel download = new JPanel();
                    download.setLayout(new GridLayout(0, 1));
                    download.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("QUERYPROTOCOLSETTINGS")));
                    JPanel maxNumberOfDownloads = new JPanel();
                    maxNumberOfDownloads.setSize(450, 20);
                    JLabel maxNumberOfDownloadsLabel1 = new JLabel(LanguageConstants.get("MAXNUMBEROFDOWNLOADS"));
                    maxNumberOfDownloads.add(maxNumberOfDownloadsLabel1);
                    int maxNumberOfDownloadsValue = (Integer)node.getAttribut("maxNumberOfDownloads");
                    JLabel maxNumberOfDownloadsLabel2 = new JLabel(String.valueOf(maxNumberOfDownloadsValue));
                    JSlider maxNumberOfDownloadsSlider = new JSlider(0, 20, maxNumberOfDownloadsValue);
                    maxNumberOfDownloadsSlider.addChangeListener(new ChangeListener(this, node, maxNumberOfDownloadsLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$maxNumberOfDownloadsLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$maxNumberOfDownloadsLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("maxNumberOfDownloads", new Integer(value));
                            this.val$maxNumberOfDownloadsLabel2.setText(String.valueOf(value));
                        }
                    });
                    maxNumberOfDownloads.add(maxNumberOfDownloadsSlider);
                    maxNumberOfDownloads.add(maxNumberOfDownloadsLabel2);
                    download.add(maxNumberOfDownloads);
                    JPanel maxNumberOfUploads = new JPanel();
                    maxNumberOfUploads.setSize(450, 20);
                    JLabel maxNumberOfUploadsLabel1 = new JLabel(LanguageConstants.get("MAXNUMBEROFUPLOADS"));
                    maxNumberOfUploads.add(maxNumberOfUploadsLabel1);
                    int maxNumberOfUploadsValue = (Integer)node.getAttribut("maxNumberOfUploads");
                    JLabel maxNumberOfUploadsLabel2 = new JLabel(String.valueOf(maxNumberOfUploadsValue));
                    JSlider maxNumberOfUploadsSlider = new JSlider(0, 20, maxNumberOfUploadsValue);
                    maxNumberOfUploadsSlider.addChangeListener(new ChangeListener(this, node, maxNumberOfUploadsLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$maxNumberOfUploadsLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$maxNumberOfUploadsLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("maxNumberOfUploads", new Integer(value));
                            this.val$maxNumberOfUploadsLabel2.setText(String.valueOf(value));
                        }
                    });
                    maxNumberOfUploads.add(maxNumberOfUploadsSlider);
                    maxNumberOfUploads.add(maxNumberOfUploadsLabel2);
                    download.add(maxNumberOfUploads);
                    panel.add(download);
                    JPanel queryttl = new JPanel();
                    queryttl.setSize(450, 20);
                    JLabel queryttlLabel1 = new JLabel(LanguageConstants.get("QUERYTTL"));
                    queryttl.add(queryttlLabel1);
                    int queryttlValue = (Integer)node.getAttribut("queryTtl");
                    JLabel queryttlLabel2 = new JLabel(String.valueOf(queryttlValue));
                    JSlider queryttlSlider = new JSlider(0, 20, queryttlValue);
                    queryttlSlider.addChangeListener(new ChangeListener(this, node, queryttlLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$queryttlLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$queryttlLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("queryTtl", new Integer(value));
                            this.val$queryttlLabel2.setText(String.valueOf(value));
                        }
                    });
                    queryttl.add(queryttlSlider);
                    queryttl.add(queryttlLabel2);
                    download.add(queryttl);
                    JPanel queryFrequency = new JPanel();
                    queryFrequency.setSize(450, 20);
                    JLabel queryFrequencyLabel1 = new JLabel(LanguageConstants.get("QUERYFREQUENCY"));
                    queryFrequency.add(queryFrequencyLabel1);
                    int queryFrequencyValue = (Integer)node.getAttribut("queryFrequency");
                    JLabel queryFrequencyLabel2 = new JLabel(String.valueOf(queryFrequencyValue));
                    JSlider queryFrequencySlider = new JSlider(0, 100, queryFrequencyValue);
                    queryFrequencySlider.addChangeListener(new ChangeListener(this, node, queryFrequencyLabel2){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ GnutellaNode val$node;
                        private final /* synthetic */ JLabel val$queryFrequencyLabel2;
                        {
                            this.this$1 = var1_1;
                            this.val$node = gnutellaNode;
                            this.val$queryFrequencyLabel2 = jLabel;
                        }

                        public void stateChanged(ChangeEvent arg0) {
                            int value = ((JSlider)arg0.getSource()).getValue();
                            this.val$node.setAttribut("queryFrequency", new Integer(value));
                            this.val$queryFrequencyLabel2.setText(String.valueOf(value));
                        }
                    });
                    queryFrequency.add(queryFrequencySlider);
                    queryFrequency.add(queryFrequencyLabel2);
                    download.add(queryFrequency);
                    JFrame frame = new JFrame(String.valueOf(LanguageConstants.get("EDITNODETITLE")) + node.getId());
                    frame.setSize(450, 550);
                    frame.getContentPane().add((Component)panel, "Center");
                    frame.show();
                }

                static /* synthetic */ GraphEditor access$0(9 var0) {
                    return var0.GraphEditor.this;
                }
            });
            if (cell instanceof GnutellaNode) {
                final GnutellaNode node = (GnutellaNode)cell;
                menu.add(new AbstractAction(LanguageConstants.get("SHAREDFILES")){

                    public void actionPerformed(ActionEvent e) {
                        JTable table = new JTable(new AbstractTableModel(this, node){
                            final String[] columnNames;
                            final /* synthetic */ 23 this$1;
                            private final /* synthetic */ GnutellaNode val$node;
                            {
                                this.this$1 = var1_1;
                                this.val$node = gnutellaNode;
                                this.columnNames = new String[]{LanguageConstants.get("FILENAMECOLUMN"), LanguageConstants.get("FILESIZECOLUMN")};
                            }

                            public int getRowCount() {
                                return (Integer)this.val$node.getAttribut("numberOfFiles");
                            }

                            public int getColumnCount() {
                                return this.columnNames.length;
                            }

                            public String getColumnName(int col) {
                                return this.columnNames[col];
                            }

                            public Object getValueAt(int row, int col) {
                                File f = ((File[])this.val$node.getAttribut("ownedFiles"))[row];
                                if (col == 0) {
                                    return f.getFileName();
                                }
                                return new Long(f.getFileSize());
                            }
                        });
                        table.setShowGrid(true);
                        JScrollPane scroll = new JScrollPane(table);
                        JFrame frame = new JFrame(String.valueOf(LanguageConstants.get("SHAREDFILESTITLE")) + node.getId());
                        frame.setSize(450, 250);
                        frame.getContentPane().add((Component)scroll, "Center");
                        frame.show();
                    }
                });
                menu.add(new StatisticAction(node));
            }
            if (cell instanceof RoutingEdge) {
                menu.add(new RoutingEdgeStatisticAction((RoutingEdge)cell));
            }
        }
        return menu;
    }

    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        URL insertUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/insert.gif");
        ImageIcon insertIcon = new ImageIcon(insertUrl, "");
        JButton b = new JButton();
        b.setIcon(insertIcon);
        b.setToolTipText(LanguageConstants.get("NEWNODE"));
        b.addActionListener(new AbstractAction("", insertIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.insert(new Point(10, 10));
            }
        });
        toolbar.add(b);
        URL connectUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connectoff.gif");
        ImageIcon connectIcon = new ImageIcon(connectUrl);
        final JButton bb = new JButton();
        bb.setIcon(connectIcon);
        bb.setToolTipText(LanguageConstants.get("CONNECTONOFF"));
        bb.addActionListener(new AbstractAction("", connectIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.graph.setPortsVisible(!GraphEditor.this.graph.isPortsVisible());
                URL connectUrl = GraphEditor.this.graph.isPortsVisible() ? this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connecton.gif") : this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connectoff.gif");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                bb.setIcon(connectIcon);
            }
        });
        toolbar.add(bb);
        toolbar.addSeparator();
        URL undoUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/undo.gif");
        ImageIcon undoIcon = new ImageIcon(undoUrl);
        this.undo = new AbstractAction("", undoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.undo();
            }
        };
        this.undo.setEnabled(false);
        toolbar.add(this.undo);
        URL redoUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/redo.gif");
        ImageIcon redoIcon = new ImageIcon(redoUrl);
        this.redo = new AbstractAction("", redoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.redo();
            }
        };
        this.redo.setEnabled(false);
        toolbar.add(this.redo);
        toolbar.addSeparator();
        toolbar.addSeparator();
        URL zoomUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoom.gif");
        ImageIcon zoomIcon = new ImageIcon(zoomUrl);
        b = new JButton();
        b.setToolTipText(LanguageConstants.get("NORMALZOOM"));
        b.setIcon(zoomIcon);
        b.addActionListener(new AbstractAction("", zoomIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.graph.setScale(1.0);
            }
        });
        toolbar.add(b);
        URL zoomInUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoomin.gif");
        ImageIcon zoomInIcon = new ImageIcon(zoomInUrl);
        b = new JButton();
        b.setToolTipText(LanguageConstants.get("ZOOMIN"));
        b.setIcon(zoomInIcon);
        b.addActionListener(new AbstractAction("", zoomInIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.graph.setScale(2.0 * GraphEditor.this.graph.getScale());
            }
        });
        toolbar.add(b);
        URL zoomOutUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoomout.gif");
        ImageIcon zoomOutIcon = new ImageIcon(zoomOutUrl);
        b = new JButton();
        b.setToolTipText(LanguageConstants.get("ZOOMOUT"));
        b.setIcon(zoomOutIcon);
        b.addActionListener(new AbstractAction("", zoomOutIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEditor.this.graph.setScale(GraphEditor.this.graph.getScale() / 2.0);
            }
        });
        toolbar.add(b);
        toolbar.addSeparator();
        URL playUrl = this.getClass().getClassLoader().getResource("gnutellasim/gui/images/play.gif");
        ImageIcon playIcon = new ImageIcon(playUrl);
        this.simulation = new Simulation(0, GnutellaGraph.getGraph());
        final JButton playButton = new JButton();
        playButton.setIcon(playIcon);
        playButton.setToolTipText(LanguageConstants.get("STARTSTOP"));
        playButton.addActionListener(new AbstractAction("", playIcon){

            public void actionPerformed(ActionEvent e) {
                URL playURL;
                if (GraphEditor.this.simulation.isPaused()) {
                    GraphEditor.this.simulation = new Simulation(Simulation.getCycle(), GnutellaGraph.getGraph());
                    GraphEditor.this.simulation.start();
                    playURL = this.getClass().getClassLoader().getResource("gnutellasim/gui/images/pause.gif");
                } else {
                    GraphEditor.this.simulation.pause();
                    playURL = this.getClass().getClassLoader().getResource("gnutellasim/gui/images/play.gif");
                }
                ImageIcon playIcon = new ImageIcon(playURL);
                playButton.setIcon(playIcon);
            }
        });
        toolbar.add(playButton);
        toolbar.addSeparator();
        JLabel speedL = new JLabel("animation speed");
        toolbar.add(speedL);
        String[] entries = new String[]{LanguageConstants.get("SLOW"), LanguageConstants.get("NORMAL"), LanguageConstants.get("FAST")};
        JComboBox<String> box = new JComboBox<String>(entries);
        box.setSelectedIndex(1);
        box.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int selectindex = cb.getSelectedIndex();
                if (selectindex == 0) {
                    Network.get().setSpeed(100);
                } else if (selectindex == 1) {
                    Network.get().setSpeed(25);
                } else if (selectindex == 2) {
                    Network.get().setSpeed(4);
                }
            }
        });
        toolbar.add(box);
        toolbar.addSeparator();
        final JLabel step = new JLabel(String.valueOf(LanguageConstants.get("STEP")) + " 0000");
        toolbar.add(step);
        Simulation.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int cycle = Simulation.getCycle();
                String nr = "";
                nr = cycle < 10 ? " 000" + cycle : (cycle < 100 ? " 00" + cycle : (cycle < 1000 ? " 0" + cycle : " " + cycle));
                step.setText(String.valueOf(LanguageConstants.get("STEP")) + nr);
            }
        });
        return toolbar;
    }

    public void group(Object[] cells) {
        cells = this.graph.getGraphLayoutCache().order(cells);
        if (cells != null && cells.length > 0) {
            int count = this.getCellCount(this.graph);
            DefaultGraphCell group = new DefaultGraphCell(new Integer(count - 1));
            ParentMap map = new ParentMap();
            int i = 0;
            while (i < cells.length) {
                map.addEntry(cells[i], group);
                ++i;
            }
            this.graph.getGraphLayoutCache().insert(new Object[]{group}, null, null, map, null);
        }
    }

    protected int getCellCount(JGraph graph) {
        Object[] cells = graph.getDescendants(graph.getRoots());
        return cells.length;
    }

    public void ungroup(Object[] cells) {
        if (cells != null && cells.length > 0) {
            ArrayList<Object> groups = new ArrayList<Object>();
            ArrayList<Object> children = new ArrayList<Object>();
            int i = 0;
            while (i < cells.length) {
                if (this.isGroup(cells[i])) {
                    groups.add(cells[i]);
                    int j = 0;
                    while (j < this.graph.getModel().getChildCount(cells[i])) {
                        Object child = this.graph.getModel().getChild(cells[i], j);
                        if (!(child instanceof Port)) {
                            children.add(child);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.graph.getGraphLayoutCache().remove(groups.toArray());
            this.graph.setSelectionCells(children.toArray());
        }
    }

    public boolean isGroup(Object cell) {
        CellView view = this.graph.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public void toFront(Object[] c) {
        this.graph.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.graph.getGraphLayoutCache().toBack(c);
    }

    public JMenuBar getMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuGlobal = new JMenu(LanguageConstants.get("GLOBALSTATISTIC"));
        menuGlobal.setMnemonic(71);
        menuBar.add(menuGlobal);
        JMenuItem menuItemGlobal = new JMenuItem(LanguageConstants.get("GLOBALSTATISTIC"), 67);
        menuItemGlobal.addActionListener(new GlobalStatisticAction(GnutellaGraph.getGraph()));
        menuGlobal.add(menuItemGlobal);
        JMenu info = new JMenu(LanguageConstants.get("INFO"));
        info.setMnemonic(73);
        JMenuItem infoItem = new JMenuItem(LanguageConstants.get("INFO"), 73);
        infoItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                JFrame frame = new JFrame();
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                URL title = this.getClass().getClassLoader().getResource("gnutellasim/gui/images/title.gif");
                ImageIcon pictureI = new ImageIcon(title);
                JLabel pic = new JLabel(pictureI);
                p.add((Component)pic, "North");
                frame.getContentPane().add(p);
                frame.setSize(470, 600);
                JTextArea text = new JTextArea("Programmer: Benno Baumgartner Benno@student.ethz.ch\n27.09.2004 R2\n\nThis program is free software; you can redistribute it and/or modify\nit under the terms of the GNU Lesser General Public License version 2 as\npublished by the Free Software Foundation.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU Lesser General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n");
                p.add((Component)text, "South");
                frame.setDefaultCloseOperation(1);
                frame.show();
            }
        });
        info.add(infoItem);
        menuBar.add(info);
        return menuBar;
    }

    protected void updateHistoryButtons() {
        this.undo.setEnabled(this.undoManager.canUndo(this.graph.getGraphLayoutCache()));
        this.redo.setEnabled(this.undoManager.canRedo(this.graph.getGraphLayoutCache()));
    }

    protected class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a) {
            super("", (ImageIcon)a.getValue("SmallIcon"));
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(GraphEditor.this.graph, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }
}

