/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.gui;

import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.gui.GraphEditor;
import gnutellasim.gui.LanguageConstants;
import gnutellasim.protocols.PingPong;
import gnutellasim.protocols.QueryReplay;
import gnutellasim.simulation.Simulation;
import gnutellasim.statistics.BufferStatisticCollector;
import gnutellasim.statistics.ConnectionsStatisticCollector;
import gnutellasim.statistics.GlobalAllStatisticCollector;
import gnutellasim.statistics.PacketStatisticCollector;
import gnutellasim.statistics.RoutingEdgeStatisticCollector;
import gnutellasim.statistics.UpDownStatisticCollector;
import gnutellasim.util.ConstantNumberGenerator;
import gnutellasim.util.DefaultValues;
import gnutellasim.util.GaussianNumberGenerator;
import gnutellasim.util.LinearNumberGenerator;
import gnutellasim.util.NumberGenerator;
import gnutellasim.view.GnutellaEdgeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jgraph.graph.EdgeView;

public class LayoutWizard
extends JFrame {
    private JSplitPane split;
    static /* synthetic */ Class class$0;

    private void initProtocolStack(DefaultValues dv) {
        Simulation.addProtocol(new PingPong());
        Simulation.addProtocol(new QueryReplay());
    }

    private void initStatisticStack(DefaultValues dv) {
        Simulation.addNodeStatisticCollector(new BufferStatisticCollector());
        Simulation.addNodeStatisticCollector(new ConnectionsStatisticCollector());
        Simulation.addNodeStatisticCollector(new UpDownStatisticCollector());
        Simulation.addNodeStatisticCollector(new PacketStatisticCollector());
        Simulation.addEdgeStatisticCollector(new RoutingEdgeStatisticCollector());
        Simulation.addGlobalStatisticCollector(new GlobalAllStatisticCollector());
    }

    private void createAndShowEditor(GnutellaGraph graph) {
        URL jgraphUrl;
        EdgeView.renderer = new GnutellaEdgeRenderer();
        JFrame frame = new JFrame("GnutellaSim");
        frame.setDefaultCloseOperation(3);
        GraphEditor editor = new GraphEditor(graph);
        frame.getContentPane().add(editor);
        frame.setJMenuBar(editor.getMenu());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gnutellasim.gui.GraphEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((jgraphUrl = clazz.getClassLoader().getResource("gnutellasim/gui/resources/jgraph.gif")) != null) {
            ImageIcon jgraphIcon = new ImageIcon(jgraphUrl);
            frame.setIconImage(jgraphIcon.getImage());
        }
        frame.setSize(800, 600);
        frame.show();
    }

    public LayoutWizard() {
        super(LanguageConstants.get("LAYOUTWIZARDTITEL"));
        JPanel base = new JPanel();
        base.setSize(500, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)base, "Center");
        this.split = new JSplitPane();
        this.split.setOneTouchExpandable(true);
        this.split.setDividerLocation(200);
        base.setLayout(new BorderLayout());
        base.add((Component)this.split, "Center");
        JPanel navi = new JPanel();
        navi.setLayout(new BorderLayout());
        final JButton next = new JButton(LanguageConstants.get("OK"));
        navi.add((Component)next, "East");
        base.add((Component)navi, "South");
        next.setEnabled(false);
        DefaultMutableTreeNode root = this.createLayoutTree();
        final JTree tree = new JTree(root);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent arg0) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    next.setEnabled(false);
                    return;
                }
                Object nodeInfo = node.getUserObject();
                LayoutInfo info = (LayoutInfo)nodeInfo;
                LayoutWizard.this.split.setRightComponent(info.getContentPane());
                if (node.isLeaf()) {
                    next.setEnabled(true);
                } else {
                    next.setEnabled(false);
                }
                LayoutWizard.this.split.setDividerLocation(LayoutWizard.this.split.getDividerLocation());
            }
        });
        this.split.setLeftComponent(tree);
        this.split.setRightComponent(((LayoutInfo)root.getUserObject()).getContentPane());
        final LayoutWizard thisFrame = this;
        next.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SettingsSite cs;
                SettingsWizard sw;
                thisFrame.setVisible(false);
                LayoutInfo node = (LayoutInfo)((DefaultMutableTreeNode)tree.getLastSelectedPathComponent()).getUserObject();
                if (node.getNodeText().equals(LanguageConstants.get("EMPTY"))) {
                    sw = new SettingsWizard(LanguageConstants.get("EMPTY"));
                    sw.addSite(new NodeSettingSite(LanguageConstants.get("NODESETTINGS")));
                    sw.addSite(new PingPongSettings(LanguageConstants.get("PINGPROTOCOLSETTINGS")));
                    sw.addSite(new QueryHitSettings(LanguageConstants.get("QUERYPROTOCOLSETTINGS")));
                    sw.addSite(new EdgeSettings(LanguageConstants.get("EDGESETTINGS")));
                    sw.setStartEditorAction(new AbstractAction(this){
                        final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            DefaultValues dv = (DefaultValues)arg0.getSource();
                            LayoutWizard.access$2(12.access$0(this.this$1), dv);
                            LayoutWizard.access$3(12.access$0(this.this$1), dv);
                            LayoutWizard.access$4(12.access$0(this.this$1), GnutellaGraph.getGraph());
                        }
                    });
                    sw.expandAll();
                    sw.setSize(700, 500);
                    sw.show();
                }
                if (node.getNodeText().equals(LanguageConstants.get("CIRCLE"))) {
                    sw = new SettingsWizard(LanguageConstants.get("CIRCLE"));
                    sw.addSite(new NodeSettingSite(LanguageConstants.get("NODESETTINGS")));
                    sw.addSite(new PingPongSettings(LanguageConstants.get("PINGPROTOCOLSETTINGS")));
                    sw.addSite(new QueryHitSettings(LanguageConstants.get("QUERYPROTOCOLSETTINGS")));
                    sw.addSite(new EdgeSettings(LanguageConstants.get("EDGESETTINGS")));
                    cs = new CircleSettings(LanguageConstants.get("CIRCLESETTINGS"));
                    sw.addSite(cs);
                    sw.setStartEditorAction(new AbstractAction(this, (CircleSettings)cs){
                        final /* synthetic */ 12 this$1;
                        private final /* synthetic */ CircleSettings val$cs;
                        {
                            this.this$1 = var1_1;
                            this.val$cs = circleSettings;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            DefaultValues dv = (DefaultValues)arg0.getSource();
                            LayoutWizard.access$2(12.access$0(this.this$1), dv);
                            LayoutWizard.access$3(12.access$0(this.this$1), dv);
                            LayoutWizard.access$4(12.access$0(this.this$1), this.createCircle(GnutellaGraph.getGraph(), this.val$cs));
                        }

                        private GnutellaGraph createCircle(GnutellaGraph graph, CircleSettings cs) {
                            int nr = cs.getNrOfNodes();
                            int centerX = 380;
                            int centerY = 240;
                            int radius = 220;
                            double angle = 0.0;
                            GnutellaNode[] gn = new GnutellaNode[nr];
                            int i = 0;
                            while (i < nr) {
                                int x = (int)Math.round((double)centerX - Math.sin(angle) * (double)radius);
                                int y = (int)Math.round((double)centerY - Math.cos(angle) * (double)radius);
                                angle += Math.PI * 2 / (double)nr;
                                gn[i] = new GnutellaNode(x, y);
                                graph.addNode(gn[i]);
                                ++i;
                            }
                            RoutingEdge[] re = new RoutingEdge[nr];
                            int i2 = 0;
                            while (i2 < nr) {
                                re[i2] = new RoutingEdge();
                                graph.addEdge(re[i2], gn[i2], gn[(i2 + 1) % nr]);
                                ++i2;
                            }
                            return graph;
                        }
                    });
                    sw.expandAll();
                    sw.setSize(700, 500);
                    sw.show();
                }
                if (node.getNodeText().equals(LanguageConstants.get("GRID"))) {
                    sw = new SettingsWizard(LanguageConstants.get("CIRCLE"));
                    sw.addSite(new NodeSettingSite(LanguageConstants.get("NODESETTINGS")));
                    sw.addSite(new PingPongSettings(LanguageConstants.get("PINGPROTOCOLSETTINGS")));
                    sw.addSite(new QueryHitSettings(LanguageConstants.get("QUERYPROTOCOLSETTINGS")));
                    sw.addSite(new EdgeSettings(LanguageConstants.get("EDGESETTINGS")));
                    cs = new GridSettings(LanguageConstants.get("GRIDSETTINGS"));
                    sw.addSite(cs);
                    sw.setStartEditorAction(new AbstractAction(this, (GridSettings)cs){
                        final /* synthetic */ 12 this$1;
                        private final /* synthetic */ GridSettings val$cs;
                        {
                            this.this$1 = var1_1;
                            this.val$cs = gridSettings;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            DefaultValues dv = (DefaultValues)arg0.getSource();
                            LayoutWizard.access$2(12.access$0(this.this$1), dv);
                            LayoutWizard.access$3(12.access$0(this.this$1), dv);
                            LayoutWizard.access$4(12.access$0(this.this$1), this.createGrid(GnutellaGraph.getGraph(), this.val$cs));
                        }

                        private GnutellaGraph createGrid(GnutellaGraph graph, GridSettings cs) {
                            int j;
                            int width = 740;
                            int height = 450;
                            int countX = cs.getNrOfNodesHorizontal();
                            int countY = cs.getNrOfNodesVertical();
                            int posX = 0;
                            int posY = 0;
                            GnutellaNode[][] matrix = new GnutellaNode[countX][countY];
                            int i = 0;
                            while (i < countX) {
                                j = 0;
                                while (j < countY) {
                                    matrix[i][j] = new GnutellaNode(i * (width / (countX - 1)) + posX, j * (height / (countY - 1)) + posY);
                                    graph.addNode(matrix[i][j]);
                                    ++j;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < countX) {
                                j = 1;
                                while (j < countY) {
                                    graph.addEdge(new RoutingEdge(), matrix[i][j - 1], matrix[i][j]);
                                    ++j;
                                }
                                ++i;
                            }
                            i = 1;
                            while (i < countX) {
                                j = 0;
                                while (j < countY) {
                                    graph.addEdge(new RoutingEdge(), matrix[i - 1][j], matrix[i][j]);
                                    ++j;
                                }
                                ++i;
                            }
                            return graph;
                        }
                    });
                    sw.expandAll();
                    sw.setSize(700, 500);
                    sw.show();
                }
                if (node.getNodeText().equals(LanguageConstants.get("STAR"))) {
                    sw = new SettingsWizard(LanguageConstants.get("CIRCLE"));
                    sw.addSite(new NodeSettingSite(LanguageConstants.get("NODESETTINGS")));
                    sw.addSite(new PingPongSettings(LanguageConstants.get("PINGPROTOCOLSETTINGS")));
                    sw.addSite(new QueryHitSettings(LanguageConstants.get("QUERYPROTOCOLSETTINGS")));
                    sw.addSite(new EdgeSettings(LanguageConstants.get("EDGESETTINGS")));
                    cs = new StarSettings(LanguageConstants.get("STARSETTINGS"));
                    sw.addSite(cs);
                    sw.setStartEditorAction(new AbstractAction(this, (StarSettings)cs){
                        final /* synthetic */ 12 this$1;
                        private final /* synthetic */ StarSettings val$cs;
                        {
                            this.this$1 = var1_1;
                            this.val$cs = starSettings;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            DefaultValues dv = (DefaultValues)arg0.getSource();
                            LayoutWizard.access$2(12.access$0(this.this$1), dv);
                            LayoutWizard.access$3(12.access$0(this.this$1), dv);
                            LayoutWizard.access$4(12.access$0(this.this$1), this.createStar(GnutellaGraph.getGraph(), this.val$cs));
                        }

                        private GnutellaGraph createStar(GnutellaGraph graph, StarSettings cs) {
                            this.createStar(200, 250, 250, graph, cs);
                            return graph;
                        }

                        private void createStar(int radius, int centerX, int centerY, GnutellaGraph graph, StarSettings ss) {
                            int maxConnect = ss.getNrOfNodesIner();
                            GnutellaNode center = new GnutellaNode(centerX, centerY, false);
                            graph.addNode(center);
                            int i = 0;
                            while (i < maxConnect) {
                                int x = (int)Math.round((double)centerX - Math.sin(Math.PI * 2 / (double)maxConnect * (double)i) * (double)(radius / 2));
                                int y = (int)Math.round((double)centerY - Math.cos(Math.PI * 2 / (double)maxConnect * (double)i) * (double)(radius / 2));
                                GnutellaNode gn = new GnutellaNode(x, y);
                                graph.addNode(gn);
                                graph.addEdge(new RoutingEdge(), center, gn);
                                this.buildPart(gn, Math.PI * 2 / (double)maxConnect * (double)i, ss.getNrOfNodesOuter(), centerX, centerY, radius, graph);
                                ++i;
                            }
                        }

                        private void buildPart(GnutellaNode n, double d, int j, int centerX, int centerY, int radius, GnutellaGraph graph) {
                            double from = d - 0.41887902047863906;
                            double to = d + 0.41887902047863906;
                            double stepWidth = (to - from) / (double)(j - 1);
                            int i = 0;
                            while (i < j) {
                                int x = (int)Math.round((double)centerX - Math.sin(from) * (double)radius);
                                int y = (int)Math.round((double)centerY - Math.cos(from) * (double)radius);
                                GnutellaNode gn = new GnutellaNode(x, y, true);
                                graph.addNode(gn);
                                graph.addEdge(new RoutingEdge(), gn, n);
                                from += stepWidth;
                                ++i;
                            }
                        }
                    });
                    sw.expandAll();
                    sw.setSize(700, 500);
                    sw.show();
                }
                if (node.getNodeText().equals(LanguageConstants.get("RANDOM"))) {
                    sw = new SettingsWizard(LanguageConstants.get("EMPTY"));
                    sw.addSite(new NodeSettingSite(LanguageConstants.get("NODESETTINGS")));
                    sw.addSite(new PingPongSettings(LanguageConstants.get("PINGPROTOCOLSETTINGS")));
                    sw.addSite(new QueryHitSettings(LanguageConstants.get("QUERYPROTOCOLSETTINGS")));
                    sw.addSite(new EdgeSettings(LanguageConstants.get("EDGESETTINGS")));
                    RandomSettings r = new RandomSettings(LanguageConstants.get("RANDOMSETTINGS"));
                    sw.addSite(r);
                    sw.setStartEditorAction(new AbstractAction(this, r){
                        final /* synthetic */ 12 this$1;
                        private final /* synthetic */ RandomSettings val$r;
                        {
                            this.this$1 = var1_1;
                            this.val$r = randomSettings;
                        }

                        public void actionPerformed(ActionEvent arg0) {
                            DefaultValues dv = (DefaultValues)arg0.getSource();
                            LayoutWizard.access$2(12.access$0(this.this$1), dv);
                            LayoutWizard.access$3(12.access$0(this.this$1), dv);
                            int nrOfNodes = this.val$r.getNrOfNodes();
                            if (nrOfNodes > 0) {
                                LayoutWizard.access$4(12.access$0(this.this$1), this.createRandom(GnutellaGraph.getGraph(), nrOfNodes));
                            } else {
                                LayoutWizard.access$4(12.access$0(this.this$1), GnutellaGraph.getGraph());
                            }
                        }

                        private GnutellaGraph createRandom(GnutellaGraph graph, int nrOfNodes) {
                            Random rng = new Random();
                            GnutellaNode prev = new GnutellaNode(rng.nextInt(600), rng.nextInt(450));
                            graph.addNode(prev);
                            int i = 0;
                            while (i < nrOfNodes - 1) {
                                GnutellaNode cur = new GnutellaNode(rng.nextInt(600), rng.nextInt(450));
                                graph.addNode(cur);
                                graph.addEdge(new RoutingEdge(), prev, cur);
                                prev = cur;
                                ++i;
                            }
                            return graph;
                        }
                    });
                    sw.expandAll();
                    sw.setSize(700, 500);
                    sw.show();
                }
            }

            static /* synthetic */ LayoutWizard access$0(12 var0) {
                return var0.LayoutWizard.this;
            }
        });
    }

    private DefaultMutableTreeNode createLayoutTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new LayoutInfo(LanguageConstants.get("LAYOUTWIZARDTITEL"), LanguageConstants.get(""), this.getClass().getClassLoader().getResource("gnutellasim/gui/images/title.gif")));
        DefaultMutableTreeNode plain = new DefaultMutableTreeNode(new LayoutInfo(LanguageConstants.get("EMPTY"), LanguageConstants.get("EMPTYDESCRIPTION"), this.getClass().getClassLoader().getResource("gnutellasim/gui/images/emptyGraph.gif")));
        root.add(plain);
        DefaultMutableTreeNode circle = new DefaultMutableTreeNode(new LayoutInfo(LanguageConstants.get("CIRCLE"), LanguageConstants.get("CIRCLEDESCRIPTION"), this.getClass().getClassLoader().getResource("gnutellasim/gui/images/circleGraph.gif")));
        root.add(circle);
        DefaultMutableTreeNode grid = new DefaultMutableTreeNode(new LayoutInfo(LanguageConstants.get("GRID"), LanguageConstants.get("GRIDDESCRIPTION"), this.getClass().getClassLoader().getResource("gnutellasim/gui/images/gridGraph.gif")));
        root.add(grid);
        DefaultMutableTreeNode star = new DefaultMutableTreeNode(new LayoutInfo(LanguageConstants.get("STAR"), LanguageConstants.get("STARDESCRIPTION"), this.getClass().getClassLoader().getResource("gnutellasim/gui/images/starGraph.gif")));
        root.add(star);
        DefaultMutableTreeNode random = new DefaultMutableTreeNode(new LayoutInfo(LanguageConstants.get("RANDOM"), LanguageConstants.get("RANDOMDESCRIPTION"), this.getClass().getClassLoader().getResource("gnutellasim/gui/images/randomGraph.gif")));
        root.add(random);
        return root;
    }

    static /* synthetic */ void access$2(LayoutWizard layoutWizard, DefaultValues defaultValues) {
        layoutWizard.initProtocolStack(defaultValues);
    }

    static /* synthetic */ void access$3(LayoutWizard layoutWizard, DefaultValues defaultValues) {
        layoutWizard.initStatisticStack(defaultValues);
    }

    static /* synthetic */ void access$4(LayoutWizard layoutWizard, GnutellaGraph gnutellaGraph) {
        layoutWizard.createAndShowEditor(gnutellaGraph);
    }

    private abstract class SettingsSite {
        protected String titel;

        SettingsSite() {
        }

        public abstract JPanel getPanel();

        public String getTitel() {
            return this.titel;
        }

        public abstract String toString();

        public abstract void setDefaultValues(DefaultValues var1);
    }

    private class RandomSettings
    extends SettingsSite {
        private JPanel base;
        private IntegerSetter nrOfNodes;
        private IntegerSetter appearRate;
        private IntegerSetter disappearRate;

        public RandomSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("CIRCLESETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.nrOfNodes = new IntegerSetter(LanguageConstants.get("NUMBEROFNODES"), 1, 10, 40, 20, 30, 20, 10);
            nodeP.add(this.nrOfNodes);
            this.appearRate = new IntegerSetter(LanguageConstants.get("APPEARRATE"), 1, 5, 50, 5, 10, 8, 3);
            nodeP.add(this.appearRate);
            this.disappearRate = new IntegerSetter(LanguageConstants.get("DISAPPEARRATE"), 1, 5, 50, 5, 10, 8, 3);
            nodeP.add(this.disappearRate);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            dv.setAppearRateGenerator(this.appearRate.getNumberGenerator());
            dv.setDisappearRateGenerator(this.disappearRate.getNumberGenerator());
        }

        public int getNrOfNodes() {
            return this.nrOfNodes.getNumberGenerator().getNumber();
        }
    }

    private class StarSettings
    extends SettingsSite {
        private JPanel base;
        private IntegerSetter nrOfNodesIner;
        private IntegerSetter nrOfNodesOuter;

        public StarSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("CIRCLESETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.nrOfNodesIner = new IntegerSetter(String.valueOf(LanguageConstants.get("NUMBEROFNODES")) + LanguageConstants.get("INER"), 1, 5, 20, 5, 10, 8, 3);
            nodeP.add(this.nrOfNodesIner);
            this.nrOfNodesOuter = new IntegerSetter(String.valueOf(LanguageConstants.get("NUMBEROFNODES")) + LanguageConstants.get("OUTER"), 1, 5, 20, 5, 10, 8, 3);
            nodeP.add(this.nrOfNodesOuter);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
        }

        public int getNrOfNodesIner() {
            return this.nrOfNodesIner.getNumberGenerator().getNumber();
        }

        public int getNrOfNodesOuter() {
            return this.nrOfNodesOuter.getNumberGenerator().getNumber();
        }
    }

    private class GridSettings
    extends SettingsSite {
        private JPanel base;
        private IntegerSetter nrOfNodesHorizontal;
        private IntegerSetter nrOfNodesVertical;
        private int nrOfNodesFrezedHorizontal;
        private int nrOfNodesFrezedVertical;

        public GridSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("CIRCLESETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.nrOfNodesHorizontal = new IntegerSetter(String.valueOf(LanguageConstants.get("NUMBEROFNODES")) + LanguageConstants.get("HORIZONTAL"), 1, 5, 20, 5, 10, 8, 3);
            nodeP.add(this.nrOfNodesHorizontal);
            this.nrOfNodesVertical = new IntegerSetter(String.valueOf(LanguageConstants.get("NUMBEROFNODES")) + LanguageConstants.get("HORIZONTAL"), 1, 5, 20, 5, 10, 8, 3);
            nodeP.add(this.nrOfNodesVertical);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            this.nrOfNodesFrezedHorizontal = this.nrOfNodesHorizontal.getNumberGenerator().getNumber();
            this.nrOfNodesFrezedVertical = this.nrOfNodesVertical.getNumberGenerator().getNumber();
        }

        public int getNrOfNodesHorizontal() {
            return this.nrOfNodesFrezedHorizontal;
        }

        public int getNrOfNodesVertical() {
            return this.nrOfNodesFrezedVertical;
        }
    }

    private class CircleSettings
    extends SettingsSite {
        private JPanel base;
        private IntegerSetter nrOfNodes;
        private int nrOfNodesFrezed;

        public CircleSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("CIRCLESETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.nrOfNodes = new IntegerSetter(LanguageConstants.get("NUMBEROFNODES"), 1, 15, 30, 10, 20, 20, 10);
            nodeP.add(this.nrOfNodes);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            this.nrOfNodesFrezed = this.nrOfNodes.getNumberGenerator().getNumber();
        }

        public int getNrOfNodes() {
            return this.nrOfNodesFrezed;
        }
    }

    private class NodeSettingSite
    extends SettingsSite {
        private JPanel base;
        private IntegerSetter buffer;
        private JCheckBox active;
        private IntegerSetter nrOfFiles;

        public NodeSettingSite(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("NODESETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.buffer = new IntegerSetter(LanguageConstants.get("MAXBUFFERSIZE"), 3, 200, 1000, 100, 200, 150, 50);
            nodeP.add(this.buffer);
            this.nrOfFiles = new IntegerSetter(LanguageConstants.get("NUMBEROFFILES"), 3, 5, 100, 0, 20, 20, 10);
            nodeP.add(this.nrOfFiles);
            JPanel activeP = new JPanel();
            activeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("ACTIVENODE")));
            this.active = new JCheckBox();
            this.active.setSelected(true);
            activeP.add(this.active);
            nodeP.add(activeP);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            dv.setBufferSizeGenerator(this.buffer.getNumberGenerator());
            dv.setActive(this.active.isSelected());
            dv.setNumberOfFilesGenerator(this.nrOfFiles.getNumberGenerator());
        }
    }

    private class PingPongSettings
    extends SettingsSite {
        private IntegerSetter min;
        private IntegerSetter max;
        private IntegerSetter ttl;
        private IntegerSetter frequency;
        private JPanel base;

        public PingPongSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("PINGPONGPROTOCOLSETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.min = new IntegerSetter(LanguageConstants.get("MINCONNECTIONS"), 3, 5, 50, 1, 5, 10, 5);
            nodeP.add(this.min);
            this.max = new IntegerSetter(LanguageConstants.get("MAXCONNECTIONS"), 3, 10, 50, 5, 10, 20, 5);
            nodeP.add(this.max);
            this.ttl = new IntegerSetter(LanguageConstants.get("PINGTTL"), 3, 3, 20, 2, 5, 5, 2);
            nodeP.add(this.ttl);
            this.frequency = new IntegerSetter(LanguageConstants.get("PINGFREQUENCY"), 3, 5, 40, 3, 10, 10, 5);
            nodeP.add(this.frequency);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            dv.setMinConnectionsGenerator(this.min.getNumberGenerator());
            dv.setMaxConnectionsGenerator(this.max.getNumberGenerator());
            dv.setPingTtlGenerator(this.ttl.getNumberGenerator());
            dv.setPingFrequencyGenerator(this.frequency.getNumberGenerator());
        }
    }

    private class QueryHitSettings
    extends SettingsSite {
        private IntegerSetter maxUp;
        private IntegerSetter maxDown;
        private IntegerSetter ttl;
        private IntegerSetter frequency;
        private JPanel base;

        public QueryHitSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("PINGPONGPROTOCOLSETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.maxUp = new IntegerSetter(LanguageConstants.get("MAXNUMBEROFUPLOADS"), 3, 3, 50, 1, 5, 5, 2);
            nodeP.add(this.maxUp);
            this.maxDown = new IntegerSetter(LanguageConstants.get("MAXNUMBEROFDOWNLOADS"), 3, 3, 50, 1, 5, 5, 2);
            nodeP.add(this.maxDown);
            this.ttl = new IntegerSetter(LanguageConstants.get("QUERYTTL"), 3, 10, 50, 3, 10, 8, 3);
            nodeP.add(this.ttl);
            this.frequency = new IntegerSetter(LanguageConstants.get("QUERYFREQUENCY"), 3, 15, 50, 10, 20, 30, 5);
            nodeP.add(this.frequency);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            dv.setMaxUploadsGenerator(this.maxUp.getNumberGenerator());
            dv.setMaxDownloadsGenerator(this.maxDown.getNumberGenerator());
            dv.setQueryTtlGenerator(this.ttl.getNumberGenerator());
            dv.setQueryFrequency(this.frequency.getNumberGenerator());
        }
    }

    private class EdgeSettings
    extends SettingsSite {
        private JPanel base;
        private IntegerSetter routing;
        private IntegerSetter download;

        public EdgeSettings(String titel) {
            this.titel = titel;
            this.base = new JPanel();
            this.base.setLayout(new BorderLayout());
            JPanel nodeP = new JPanel();
            nodeP.setBorder(BorderFactory.createTitledBorder(LanguageConstants.get("NODESETTINGS")));
            nodeP.setLayout(new GridLayout(0, 1));
            this.routing = new IntegerSetter(LanguageConstants.get("EDGECAPACITY"), 3, 10, 100, 5, 20, 15, 5);
            nodeP.add(this.routing);
            this.download = new IntegerSetter(LanguageConstants.get("DOWNLOADEDGECAPACITY"), 3, 64, 1024, 8, 128, 64, 32);
            nodeP.add(this.download);
            this.base.add((Component)nodeP, "North");
            this.base.add((Component)new JPanel(), "Center");
        }

        public JPanel getPanel() {
            return this.base;
        }

        public String toString() {
            return this.titel;
        }

        public void setDefaultValues(DefaultValues dv) {
            dv.setRoutingEdgeCapacityGenerator(this.routing.getNumberGenerator());
            dv.setDownloadEdgeCapacityGenerator(this.download.getNumberGenerator());
        }
    }

    private class IntegerSetter
    extends JPanel {
        private int selection;
        private int constValue;
        private int minValue;
        private int maxValue;
        private int meanValue;
        private int deviationValue;

        public IntegerSetter(String titel, int defaultSelection, int constV, int maxConst, int minLinear, int maxLinear, int mean, int deviation) {
            this.selection = defaultSelection;
            this.setBorder(BorderFactory.createTitledBorder(titel));
            this.setLayout(new BorderLayout());
            JPanel constP = new JPanel();
            JPanel linearP = new JPanel();
            JPanel gaussP = new JPanel();
            JPanel radio = new JPanel();
            radio.setLayout(new FlowLayout());
            JRadioButton constant = new JRadioButton("");
            constant.setSelected(this.selection == 1);
            constant.addActionListener(new AbstractAction(this, constP, linearP, gaussP){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JPanel val$constP;
                private final /* synthetic */ JPanel val$linearP;
                private final /* synthetic */ JPanel val$gaussP;
                {
                    this.this$1 = integerSetter;
                    this.val$constP = jPanel;
                    this.val$linearP = jPanel2;
                    this.val$gaussP = jPanel3;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.val$constP.setVisible(true);
                    this.val$linearP.setVisible(false);
                    this.val$gaussP.setVisible(false);
                    IntegerSetter.access$0(this.this$1, 1);
                }
            });
            radio.add(constant);
            radio.add(new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("gnutellasim/gui/images/constant.gif"))));
            JRadioButton linear = new JRadioButton("");
            linear.setSelected(this.selection == 2);
            linear.addActionListener(new AbstractAction(this, constP, linearP, gaussP){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JPanel val$constP;
                private final /* synthetic */ JPanel val$linearP;
                private final /* synthetic */ JPanel val$gaussP;
                {
                    this.this$1 = integerSetter;
                    this.val$constP = jPanel;
                    this.val$linearP = jPanel2;
                    this.val$gaussP = jPanel3;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.val$constP.setVisible(false);
                    this.val$linearP.setVisible(true);
                    this.val$gaussP.setVisible(false);
                    IntegerSetter.access$0(this.this$1, 2);
                }
            });
            radio.add(linear);
            radio.add(new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("gnutellasim/gui/images/linear.gif"))));
            JRadioButton gauss = new JRadioButton("");
            gauss.setSelected(this.selection == 3);
            gauss.addActionListener(new AbstractAction(this, constP, linearP, gaussP){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JPanel val$constP;
                private final /* synthetic */ JPanel val$linearP;
                private final /* synthetic */ JPanel val$gaussP;
                {
                    this.this$1 = integerSetter;
                    this.val$constP = jPanel;
                    this.val$linearP = jPanel2;
                    this.val$gaussP = jPanel3;
                }

                public void actionPerformed(ActionEvent arg0) {
                    this.val$constP.setVisible(false);
                    this.val$linearP.setVisible(false);
                    this.val$gaussP.setVisible(true);
                    IntegerSetter.access$0(this.this$1, 3);
                }
            });
            radio.add(gauss);
            radio.add(new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("gnutellasim/gui/images/gauss.gif"))));
            this.add((Component)radio, "West");
            ButtonGroup g = new ButtonGroup();
            g.add(constant);
            g.add(linear);
            g.add(gauss);
            JPanel value = new JPanel();
            value.setLayout(new FlowLayout());
            JLabel lable2 = new JLabel(String.valueOf(constV));
            this.constValue = constV;
            JSlider slider1 = new JSlider(0, maxConst, constV);
            slider1.addChangeListener(new ChangeListener(this, lable2){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JLabel val$lable2;
                {
                    this.this$1 = integerSetter;
                    this.val$lable2 = jLabel;
                }

                public void stateChanged(ChangeEvent arg0) {
                    this.val$lable2.setText(String.valueOf(((JSlider)arg0.getSource()).getValue()));
                    IntegerSetter.access$1(this.this$1, ((JSlider)arg0.getSource()).getValue());
                }
            });
            constP.add(slider1);
            constP.add(lable2);
            constP.setVisible(this.selection == 1);
            value.add(constP);
            linearP.setSize(100, 20);
            JLabel min = new JLabel(LanguageConstants.get("MIN"));
            linearP.add(min);
            JTextField minF = new JTextField(4);
            JTextField maxF = new JTextField(4);
            minF.setText(String.valueOf(minLinear));
            this.minValue = minLinear;
            minF.addFocusListener(new FocusListener(this, minF, minLinear, maxF){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JTextField val$minF;
                private final /* synthetic */ int val$minLinear;
                private final /* synthetic */ JTextField val$maxF;
                {
                    this.this$1 = integerSetter;
                    this.val$minF = jTextField;
                    this.val$minLinear = n;
                    this.val$maxF = jTextField2;
                }

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    JTextField s = this.val$minF;
                    try {
                        int maxvalue;
                        int minvalue = Integer.parseInt(s.getText());
                        IntegerSetter.access$2(this.this$1, minvalue);
                        if (minvalue < 0) {
                            s.setText("####");
                            IntegerSetter.access$2(this.this$1, this.val$minLinear);
                        } else if (!this.val$maxF.getText().equals("####") && minvalue > (maxvalue = Integer.parseInt(this.val$maxF.getText()))) {
                            this.val$maxF.setText(String.valueOf(minvalue));
                            IntegerSetter.access$3(this.this$1, minvalue);
                        }
                    }
                    catch (NumberFormatException e) {
                        s.setText("####");
                        IntegerSetter.access$2(this.this$1, this.val$minLinear);
                    }
                }
            });
            linearP.add(minF);
            JLabel max = new JLabel(LanguageConstants.get("MAX"));
            linearP.add(max);
            maxF.setText(String.valueOf(maxLinear));
            this.maxValue = maxLinear;
            maxF.addFocusListener(new FocusListener(this, maxF, maxLinear, minF){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JTextField val$maxF;
                private final /* synthetic */ int val$maxLinear;
                private final /* synthetic */ JTextField val$minF;
                {
                    this.this$1 = integerSetter;
                    this.val$maxF = jTextField;
                    this.val$maxLinear = n;
                    this.val$minF = jTextField2;
                }

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    JTextField s = this.val$maxF;
                    try {
                        int minvalue;
                        int maxvalue = Integer.parseInt(s.getText());
                        IntegerSetter.access$3(this.this$1, maxvalue);
                        if (maxvalue < 0) {
                            s.setText("####");
                            IntegerSetter.access$3(this.this$1, this.val$maxLinear);
                        } else if (!this.val$minF.getText().equals("####") && (minvalue = Integer.parseInt(this.val$minF.getText())) > maxvalue) {
                            this.val$minF.setText(String.valueOf(maxvalue));
                            IntegerSetter.access$2(this.this$1, maxvalue);
                        }
                    }
                    catch (NumberFormatException e) {
                        s.setText("####");
                        IntegerSetter.access$3(this.this$1, this.val$maxLinear);
                    }
                }
            });
            linearP.add(maxF);
            linearP.setVisible(this.selection == 2);
            value.add(linearP);
            gaussP.setSize(100, 20);
            JLabel meanL = new JLabel(LanguageConstants.get("MEAN"));
            gaussP.add(meanL);
            JTextField meanF = new JTextField(4);
            JTextField deviationF = new JTextField(4);
            meanF.setText(String.valueOf(mean));
            this.meanValue = mean;
            meanF.addFocusListener(new FocusListener(this, meanF, mean, deviationF){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JTextField val$meanF;
                private final /* synthetic */ int val$mean;
                private final /* synthetic */ JTextField val$deviationF;
                {
                    this.this$1 = integerSetter;
                    this.val$meanF = jTextField;
                    this.val$mean = n;
                    this.val$deviationF = jTextField2;
                }

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    JTextField s = this.val$meanF;
                    try {
                        int devvalue;
                        int meanvalue = Integer.parseInt(s.getText());
                        IntegerSetter.access$4(this.this$1, meanvalue);
                        if (meanvalue <= 0) {
                            s.setText("####");
                            IntegerSetter.access$4(this.this$1, this.val$mean);
                        } else if (!this.val$deviationF.getText().equals("####") && meanvalue - (devvalue = Integer.parseInt(this.val$deviationF.getText())) < 0) {
                            this.val$deviationF.setText(String.valueOf(meanvalue));
                            IntegerSetter.access$5(this.this$1, meanvalue);
                        }
                    }
                    catch (NumberFormatException e) {
                        s.setText("####");
                        IntegerSetter.access$4(this.this$1, this.val$mean);
                    }
                }
            });
            gaussP.add(meanF);
            JLabel deviationL = new JLabel(LanguageConstants.get("DEVIATION"));
            gaussP.add(deviationL);
            deviationF.setText(String.valueOf(deviation));
            this.deviationValue = deviation;
            deviationF.addFocusListener(new FocusListener(this, deviationF, deviation, meanF){
                final /* synthetic */ IntegerSetter this$1;
                private final /* synthetic */ JTextField val$deviationF;
                private final /* synthetic */ int val$deviation;
                private final /* synthetic */ JTextField val$meanF;
                {
                    this.this$1 = integerSetter;
                    this.val$deviationF = jTextField;
                    this.val$deviation = n;
                    this.val$meanF = jTextField2;
                }

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    JTextField s = this.val$deviationF;
                    try {
                        int meanvalue;
                        int devvalue = Integer.parseInt(s.getText());
                        IntegerSetter.access$5(this.this$1, devvalue);
                        if (devvalue < 1) {
                            s.setText("####");
                            IntegerSetter.access$5(this.this$1, this.val$deviation);
                        } else if (!this.val$meanF.getText().equals("####") && (meanvalue = Integer.parseInt(this.val$meanF.getText())) - devvalue < 0) {
                            this.val$meanF.setText(String.valueOf(devvalue));
                            IntegerSetter.access$4(this.this$1, devvalue);
                        }
                    }
                    catch (NumberFormatException e) {
                        s.setText("####");
                        IntegerSetter.access$5(this.this$1, this.val$deviation);
                    }
                }
            });
            gaussP.add(deviationF);
            gaussP.setVisible(this.selection == 3);
            value.add(gaussP);
            this.add((Component)value, "Center");
        }

        public NumberGenerator getNumberGenerator() {
            if (this.selection == 1) {
                return new ConstantNumberGenerator(this.constValue);
            }
            if (this.selection == 2) {
                return new LinearNumberGenerator(this.minValue, this.maxValue);
            }
            if (this.selection == 3) {
                return new GaussianNumberGenerator(this.meanValue, this.deviationValue);
            }
            return null;
        }

        static /* synthetic */ void access$0(IntegerSetter integerSetter, int n) {
            integerSetter.selection = n;
        }

        static /* synthetic */ void access$1(IntegerSetter integerSetter, int n) {
            integerSetter.constValue = n;
        }

        static /* synthetic */ void access$2(IntegerSetter integerSetter, int n) {
            integerSetter.minValue = n;
        }

        static /* synthetic */ void access$3(IntegerSetter integerSetter, int n) {
            integerSetter.maxValue = n;
        }

        static /* synthetic */ void access$4(IntegerSetter integerSetter, int n) {
            integerSetter.meanValue = n;
        }

        static /* synthetic */ void access$5(IntegerSetter integerSetter, int n) {
            integerSetter.deviationValue = n;
        }
    }

    private class SettingsWizard
    extends JFrame
    implements TreeSelectionListener {
        private AbstractAction startEditorAction;
        private DefaultMutableTreeNode root;
        private DefaultTreeModel treeModel;
        private JTree tree;
        private Vector settingsSites = new Vector();

        public SettingsWizard(String layoutName) {
            super(layoutName);
            JPanel base = new JPanel();
            base.setSize(500, 500);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)base, "Center");
            LayoutWizard.this.split = new JSplitPane();
            LayoutWizard.this.split.setOneTouchExpandable(true);
            LayoutWizard.this.split.setDividerLocation(200);
            base.setLayout(new BorderLayout());
            base.add((Component)LayoutWizard.this.split, "Center");
            JPanel navi = new JPanel();
            navi.setLayout(new BorderLayout());
            JButton ok = new JButton(LanguageConstants.get("OK"));
            navi.add((Component)ok, "East");
            base.add((Component)navi, "South");
            this.root = new DefaultMutableTreeNode(layoutName);
            this.treeModel = new DefaultTreeModel(this.root);
            this.treeModel.addTreeModelListener(new TreeModelListener(this){
                final /* synthetic */ SettingsWizard this$1;
                {
                    this.this$1 = settingsWizard;
                }

                public void treeNodesChanged(TreeModelEvent e) {
                }

                public void treeNodesInserted(TreeModelEvent arg0) {
                }

                public void treeNodesRemoved(TreeModelEvent arg0) {
                }

                public void treeStructureChanged(TreeModelEvent arg0) {
                }
            });
            this.tree = new JTree(this.root);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setShowsRootHandles(true);
            this.tree.addTreeSelectionListener(this);
            LayoutWizard.this.split.setLeftComponent(this.tree);
            LayoutWizard.this.split.setRightComponent(new JPanel());
            SettingsWizard thisFrame = this;
            ok.addActionListener(new AbstractAction(this, thisFrame){
                final /* synthetic */ SettingsWizard this$1;
                private final /* synthetic */ JFrame val$thisFrame;
                {
                    this.this$1 = settingsWizard;
                    this.val$thisFrame = jFrame;
                }

                public void actionPerformed(ActionEvent arg0) {
                    DefaultValues dv = DefaultValues.get();
                    int i = 0;
                    while (i < SettingsWizard.access$0(this.this$1).size()) {
                        ((SettingsSite)SettingsWizard.access$0(this.this$1).get(i)).setDefaultValues(dv);
                        ++i;
                    }
                    this.val$thisFrame.setVisible(false);
                    if (SettingsWizard.access$1(this.this$1) != null) {
                        SettingsWizard.access$1(this.this$1).actionPerformed(new ActionEvent(dv, 0, ""));
                    }
                }
            });
        }

        public void setStartEditorAction(AbstractAction a) {
            this.startEditorAction = a;
        }

        public void addSite(SettingsSite site) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(site);
            this.treeModel.insertNodeInto(newNode, this.root, this.root.getChildCount());
            this.settingsSites.add(site);
        }

        public void expandAll() {
            this.tree.expandPath(new TreePath(this.root.getPath()));
        }

        public void valueChanged(TreeSelectionEvent arg0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                SettingsSite site = (SettingsSite)nodeInfo;
                LayoutWizard.this.split.setRightComponent(site.getPanel());
            } else {
                JPanel panel = new JPanel();
                LayoutWizard.this.split.setRightComponent(panel);
            }
            LayoutWizard.this.split.setDividerLocation(LayoutWizard.this.split.getDividerLocation());
        }

        static /* synthetic */ Vector access$0(SettingsWizard settingsWizard) {
            return settingsWizard.settingsSites;
        }

        static /* synthetic */ AbstractAction access$1(SettingsWizard settingsWizard) {
            return settingsWizard.startEditorAction;
        }
    }

    private class LayoutInfo {
        private String nodeText;
        private String infoText;
        private URL picture;

        public LayoutInfo(String nodeText, String infoText, URL picture) {
            this.nodeText = nodeText;
            this.infoText = infoText;
            this.picture = picture;
        }

        public String getNodeText() {
            return this.nodeText;
        }

        public JPanel getContentPane() {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JTextArea text = new JTextArea(this.infoText);
            text.setLineWrap(true);
            text.setMargin(new Insets(3, 3, 3, 3));
            panel.add((Component)text, "North");
            ImageIcon pictureI = new ImageIcon(this.picture);
            JLabel pic = new JLabel(pictureI);
            panel.add((Component)pic, "Center");
            return panel;
        }

        public String toString() {
            return this.nodeText;
        }

        public String getInfo() {
            return this.infoText;
        }
    }
}

