/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.gui;

import gnutellasim.gui.GraphEditor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;

public class MyMarqueeHandler
extends BasicMarqueeHandler {
    private final GraphEditor ed;
    protected Point2D start;
    protected Point2D current;
    protected PortView port;
    protected PortView firstPort;

    MyMarqueeHandler(GraphEditor ed) {
        this.ed = ed;
    }

    public boolean isForceMarqueeEvent(MouseEvent e) {
        if (e.isShiftDown()) {
            return false;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return true;
        }
        this.port = this.getSourcePortAt(e.getPoint());
        if (this.port != null && this.ed.graph.isPortsVisible()) {
            return true;
        }
        return super.isForceMarqueeEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            Point2D loc = this.ed.graph.fromScreen((Point2D)e.getPoint().clone());
            Object cell = this.ed.graph.getFirstCellForLocation(e.getX(), e.getY());
            JPopupMenu menu = this.ed.createPopupMenu(e.getPoint(), cell);
            menu.show(this.ed.graph, e.getX(), e.getY());
        } else if (this.port != null && this.ed.graph.isPortsVisible()) {
            this.start = this.ed.graph.toScreen(this.port.getLocation(null));
            this.firstPort = this.port;
        } else {
            super.mousePressed(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.start != null) {
            Graphics g = this.ed.graph.getGraphics();
            this.paintConnector(Color.black, this.ed.graph.getBackground(), g);
            this.port = this.getTargetPortAt(e.getPoint());
            this.current = this.port != null ? this.ed.graph.toScreen(this.port.getLocation(null)) : this.ed.graph.snap(e.getPoint());
            this.paintConnector(this.ed.graph.getBackground(), Color.black, g);
        }
        super.mouseDragged(e);
    }

    public PortView getSourcePortAt(Point2D point) {
        Point2D tmp = this.ed.graph.fromScreen((Point2D)point.clone());
        return this.ed.graph.getPortViewAt(tmp.getX(), tmp.getY());
    }

    protected PortView getTargetPortAt(Point2D point) {
        Object cell = this.ed.graph.getFirstCellForLocation(point.getX(), point.getY());
        int i = 0;
        while (i < this.ed.graph.getModel().getChildCount(cell)) {
            Object tmp = this.ed.graph.getModel().getChild(cell, i);
            tmp = this.ed.graph.getGraphLayoutCache().getMapping(tmp, false);
            if (tmp instanceof PortView && tmp != this.firstPort) {
                return (PortView)tmp;
            }
            ++i;
        }
        return this.getSourcePortAt(point);
    }

    public void mouseReleased(MouseEvent e) {
        if (e != null && this.port != null && this.firstPort != null && this.firstPort != this.port) {
            this.ed.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell());
        } else {
            this.ed.graph.repaint();
        }
        this.port = null;
        this.firstPort = null;
        this.current = null;
        this.start = null;
        super.mouseReleased(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (e != null && this.getSourcePortAt(e.getPoint()) != null && this.ed.graph.isPortsVisible()) {
            this.ed.graph.setCursor(new Cursor(12));
            e.consume();
        } else {
            super.mouseMoved(e);
        }
    }

    protected void paintConnector(Color fg, Color bg, Graphics g) {
        g.setColor(fg);
        g.setXORMode(bg);
        this.paintPort(this.ed.graph.getGraphics());
        if (this.firstPort != null && this.start != null && this.current != null) {
            g.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
        }
    }

    protected void paintPort(Graphics g) {
        if (this.port != null) {
            boolean o = GraphConstants.getOffset(this.port.getAttributes()) != null;
            Rectangle2D r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
            r = this.ed.graph.toScreen((Rectangle2D)r.clone());
            r.setFrame(r.getX() - 3.0, r.getY() - 3.0, r.getWidth() + 6.0, r.getHeight() + 6.0);
            this.ed.graph.getUI().paintCell(g, this.port, r, true);
        }
    }
}

