/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.gui;

import gnutellasim.graph.GnutellaNode;
import gnutellasim.gui.LanguageConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.XYDataItem;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class StatisticAction
extends AbstractAction {
    private GnutellaNode node;

    public StatisticAction(GnutellaNode node) {
        super(LanguageConstants.get("STATISTICS"));
        this.node = node;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFrame frame = new JFrame(String.valueOf(LanguageConstants.get("STATISTICSTITLE")) + this.node.getId());
        frame.setSize(700, 500);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(LanguageConstants.get("BUFFER"), this.createTab(this.createBufferDataset()));
        tabbedPane.addTab(LanguageConstants.get("CONNECTIONS"), this.createTab(this.createConnectionsDataset()));
        tabbedPane.addTab(LanguageConstants.get("UPDOWN"), this.createTab(this.createUpDownDataset()));
        tabbedPane.addTab(LanguageConstants.get("SENDEDPACKETS"), this.createTab(this.createPacketDataset()));
        tabbedPane.addTab(LanguageConstants.get("TOTALSENDEDPACKETS"), this.createPacketTab());
        frame.getContentPane().add(tabbedPane);
        frame.show();
    }

    private JPanel createPacketTab() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.createPiePanel(this.createPacketTotalDataset(), LanguageConstants.get("SENDEDPACKETSPACKETS")));
        panel.add(this.createPiePanel(this.createPacketTotalKBDataset(), LanguageConstants.get("SENDEDPACKETSKB")));
        return panel;
    }

    private ChartPanel createPiePanel(PieDataset dataset, String titel) {
        JFreeChart chart = ChartFactory.createPieChart(titel, dataset, true, true, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setLabelFont(new Font("SansSerif", 0, 12));
        plot.setNoDataMessage("No data available");
        plot.setCircular(false);
        plot.setLabelLinkPaint(Color.red);
        plot.setLabelGap(0.02);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(330, 250));
        return chartPanel;
    }

    protected PieDataset createPacketTotalKBDataset() {
        long[] totalB = (long[])this.node.getAttribut("packetTotalBStatistic");
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"PING"), new Double((double)totalB[0] / 1024.0));
        dataset.setValue((Comparable)((Object)"PONG"), new Double((double)totalB[1] / 1024.0));
        dataset.setValue((Comparable)((Object)"QUERY"), new Double((double)totalB[2] / 1024.0));
        dataset.setValue((Comparable)((Object)"HIT"), new Double((double)totalB[3] / 1024.0));
        return dataset;
    }

    protected PieDataset createPacketTotalDataset() {
        int[] total = (int[])this.node.getAttribut("packetTotalStatistic");
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"PING"), new Double(total[0]));
        dataset.setValue((Comparable)((Object)"PONG"), new Double(total[1]));
        dataset.setValue((Comparable)((Object)"QUERY"), new Double(total[2]));
        dataset.setValue((Comparable)((Object)"HIT"), new Double(total[3]));
        return dataset;
    }

    protected XYSeriesCollection createPacketDataset() {
        XYSeries series1 = new XYSeries(LanguageConstants.get("PINGCOUNT"));
        XYSeries series2 = new XYSeries(LanguageConstants.get("PONGCOUNT"));
        XYSeries series3 = new XYSeries(LanguageConstants.get("QUERYCOUNT"));
        XYSeries series4 = new XYSeries(LanguageConstants.get("HITCOUNT"));
        Vector v = (Vector)this.node.getAttribut("packetStatistic");
        if (v.size() >= 5) {
            int i = 0;
            while (i < v.size()) {
                series1.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 1)).doubleValue());
                series2.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 2)).doubleValue());
                series3.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 3)).doubleValue());
                series4.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 4)).doubleValue());
                i += 5;
            }
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        dataset.addSeries(series3);
        dataset.addSeries(series4);
        return dataset;
    }

    protected XYSeriesCollection createUpDownDataset() {
        XYSeries series1 = new XYSeries(LanguageConstants.get("DOWNLOADSCOUNT"));
        XYSeries series2 = new XYSeries(LanguageConstants.get("UPLOADSCOUNT"));
        Vector v = (Vector)this.node.getAttribut("upDownStatistic");
        if (v.size() >= 3) {
            int i = 0;
            while (i < v.size()) {
                series1.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 1)).doubleValue());
                series2.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 2)).doubleValue());
                i += 3;
            }
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        return dataset;
    }

    protected XYSeriesCollection createConnectionsDataset() {
        XYSeries series1 = new XYSeries(LanguageConstants.get("CONNECTIONSCOUNT"));
        Vector v = (Vector)this.node.getAttribut("nrOfConnectionsStatistic");
        if (v.size() >= 2) {
            int i = 0;
            while (i < v.size()) {
                series1.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 1)).doubleValue());
                i += 2;
            }
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        return dataset;
    }

    protected XYSeriesCollection createBufferDataset() {
        XYSeries series1 = new XYSeries(LanguageConstants.get("BUFFERFILLLEVELPERCENT"));
        XYSeries series2 = new XYSeries(LanguageConstants.get("BUFFERFILLLEVELPACKET"));
        XYSeries series3 = new XYSeries(LanguageConstants.get("BUFFERSIZE"));
        Vector v = (Vector)this.node.getAttribut("bufferStatistic");
        if (v.size() >= 3) {
            int i = 0;
            while (i < v.size()) {
                series1.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 1)).doubleValue() / ((Integer)v.get(i + 2)).doubleValue() * 100.0);
                series2.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 1)).doubleValue());
                series3.add(((Integer)v.get(i)).doubleValue(), ((Integer)v.get(i + 2)).doubleValue());
                i += 3;
            }
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        dataset.addSeries(series3);
        return dataset;
    }

    private JPanel createTab(XYSeriesCollection dataset) {
        ChartPanel chart = this.createChartPanel(this.createLineChart(dataset));
        chart.setSize(650, 250);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.add(chart);
        JTable table = this.createTable(dataset);
        JScrollPane scroll = new JScrollPane(table);
        panel.add(scroll);
        return panel;
    }

    private JTable createTable(XYSeriesCollection dataset) {
        Object[] columnNames = new String[dataset.getSeriesCount() + 1];
        columnNames[0] = LanguageConstants.get("CYCLE");
        int i = 0;
        while (i < dataset.getSeriesCount()) {
            columnNames[i + 1] = dataset.getSeriesName(i);
            ++i;
        }
        Object[][] data = new Object[dataset.getSeries(0).getItemCount()][dataset.getSeriesCount() + 1];
        int i2 = 0;
        while (i2 < dataset.getSeriesCount()) {
            List list = dataset.getSeries(i2).getItems();
            int n = 0;
            while (n < list.size()) {
                XYDataItem item = (XYDataItem)list.get(n);
                data[n][i2 + 1] = item.getY();
                data[n][0] = item.getX();
                ++n;
            }
            ++i2;
        }
        JTable table = new JTable(data, columnNames);
        table.setSize(650, 200);
        return table;
    }

    private ChartPanel createChartPanel(JFreeChart chart) {
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setHorizontalZoom(true);
        chartPanel.setHorizontalAxisTrace(true);
        chartPanel.setVerticalZoom(true);
        chartPanel.setVerticalAxisTrace(true);
        chartPanel.setFillZoomRectangle(true);
        return chartPanel;
    }

    private JFreeChart createLineChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, LanguageConstants.get("CYCLE"), LanguageConstants.get("VALUE"), dataset, PlotOrientation.VERTICAL, true, true, false);
        return chart;
    }
}

