/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.message;

import gnutellasim.graph.GnutellaNode;
import gnutellasim.util.IdNumberFactory;

public abstract class Message {
    private static int HEADERSIZE = 23;
    private short[] messageId;
    private short ttlRemaining;
    private short hopsTaken;
    private GnutellaNode source;
    private GnutellaNode target;
    private int percent;

    public Message(short ttl) {
        this.messageId = IdNumberFactory.getUniqueNumber();
        this.ttlRemaining = ttl;
    }

    public Message(short[] messageId) {
        this.messageId = messageId;
    }

    public Message(short ttl, short[] messageId) {
        this.ttlRemaining = ttl;
        this.messageId = messageId;
    }

    public short[] messageId() {
        return this.messageId;
    }

    public String messageIdStr() {
        String res = "";
        int i = 0;
        while (i < this.messageId.length) {
            short s = this.messageId[i];
            res = s < 10 ? String.valueOf(res) + "00" + Short.toString(s) : (s < 100 ? String.valueOf(res) + "0" + Short.toString(s) : String.valueOf(res) + Short.toString(s));
            ++i;
        }
        return res;
    }

    public abstract short functionID();

    public short ttlRemaining() {
        return this.ttlRemaining;
    }

    public short hopsTaken() {
        return this.hopsTaken;
    }

    public void increaseHop() {
        this.hopsTaken = (short)(this.hopsTaken + 1);
        this.ttlRemaining = (short)(this.ttlRemaining - 1);
    }

    public abstract long dataLength();

    public long messageSizeInBytes() {
        return (long)HEADERSIZE + this.dataLength();
    }

    public String toString() {
        return String.valueOf(this.messageIdStr()) + " type " + this.functionID();
    }

    public abstract Object clone();

    public void setTarget(GnutellaNode target) {
        this.target = target;
    }

    public void setSource(GnutellaNode source) {
        this.source = source;
    }

    public void setPercent(int i) {
        this.percent = i;
    }

    public GnutellaNode getSource() {
        return this.source;
    }

    public GnutellaNode getTarget() {
        return this.target;
    }

    public int getPercent() {
        return this.percent;
    }
}

