/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.message;

import gnutellasim.graph.DownloadEdge;
import gnutellasim.graph.GnutellaEdge;
import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.message.Message;
import gnutellasim.protocols.Protocol;
import gnutellasim.simulation.Simulation;
import gnutellasim.statistics.EdgeStatisticCollector;
import gnutellasim.util.File;
import gnutellasim.view.GraphView;
import java.util.ArrayList;

public class Network {
    private static Network singleton;
    public GraphView view;
    private int speed = 25;
    private ArrayList protocols = new ArrayList();

    private Network() {
    }

    public static Network get() {
        if (singleton == null) {
            singleton = new Network();
        }
        return singleton;
    }

    public void send(Message msg, GnutellaNode source, GnutellaNode target) {
        msg.setSource(source);
        msg.setTarget(target);
        msg.setPercent(0);
        if (source.getMessageBuffer().full()) {
            source.setDeath(true);
            GnutellaNode[] nrs = source.getNeighbors();
            int i = 0;
            while (i < nrs.length) {
                source.removeNeighbor(nrs[i]);
                ++i;
            }
        } else {
            source.getMessageBuffer().put(msg);
        }
    }

    public synchronized void proceed() {
        RoutingEdge edge;
        ArrayList<Message> sendmsgs = new ArrayList<Message>();
        ArrayList<DownloadEdge> downloadEdges = new ArrayList<DownloadEdge>();
        int i = 0;
        while (i < GnutellaGraph.getGraph().getRootCount()) {
            Object root = GnutellaGraph.getGraph().getRootAt(i);
            if (root instanceof GnutellaNode) {
                GnutellaNode n = (GnutellaNode)root;
                int buffsize = n.getMessageBuffer().getSize();
                int nr = 0;
                while (nr < buffsize) {
                    Message msg = n.getMessageBuffer().get();
                    edge = GnutellaGraph.getGraph().edgeConnecting(msg.getSource(), msg.getTarget());
                    if (edge != null) {
                        if (edge.getCapacity() > edge.getCurrentMessages().length) {
                            edge.addMessage(msg);
                            sendmsgs.add(msg);
                        } else {
                            n.getMessageBuffer().put(msg);
                        }
                    }
                    ++nr;
                }
            } else if (root instanceof DownloadEdge) {
                DownloadEdge edge2 = (DownloadEdge)root;
                edge2.setPercent(0);
                downloadEdges.add(edge2);
            }
            ++i;
        }
        EdgeStatisticCollector[] escs = Simulation.getEdgeStatisticCollectors();
        int i2 = 0;
        while (i2 < GnutellaGraph.getGraph().getRootCount()) {
            Object root = GnutellaGraph.getGraph().getRootAt(i2);
            if (root instanceof GnutellaEdge) {
                int n = 0;
                while (n < escs.length) {
                    escs[n].collect((GnutellaEdge)root, Simulation.getCycle());
                    ++n;
                }
            }
            ++i2;
        }
        int step = 1;
        while (step <= this.getSpeed()) {
            this.view.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception root) {
                // empty catch block
            }
            int i3 = 0;
            while (i3 < sendmsgs.size()) {
                Message msg = (Message)sendmsgs.get(i3);
                GnutellaNode source = msg.getSource();
                GnutellaNode target = msg.getTarget();
                msg.setPercent(msg.getPercent() + 100 / this.getSpeed());
                if (msg.getPercent() >= 100) {
                    edge = GnutellaGraph.getGraph().edgeConnecting(source, target);
                    edge.removeMessage(msg);
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < downloadEdges.size()) {
                ((DownloadEdge)downloadEdges.get(i3)).setPercent(((DownloadEdge)downloadEdges.get(i3)).getPercent() + 100 / this.getSpeed());
                ++i3;
            }
            ++step;
        }
        this.view.repaint();
        i2 = 0;
        while (i2 < sendmsgs.size()) {
            Message msg = (Message)sendmsgs.get(i2);
            GnutellaNode source = msg.getSource();
            GnutellaNode target = msg.getTarget();
            int n = 0;
            while (n < this.protocols.size()) {
                if (((Protocol)this.protocols.get(n)).accept(msg)) {
                    ((Protocol)this.protocols.get(n)).received(msg, target, source);
                }
                ++n;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < downloadEdges.size()) {
            DownloadEdge edge3 = (DownloadEdge)downloadEdges.get(i2);
            edge3.setSend(edge3.getSend() + (long)edge3.getCapacity());
            if (edge3.getSend() >= edge3.getFileToDownload().getFileSize()) {
                GnutellaGraph.getGraph().removeEdge(edge3);
                edge3.getNode2().setAttribut("currentNumberOfDownloads", new Integer((Integer)edge3.getNode2().getAttribut("currentNumberOfDownloads") - 1));
                edge3.getNode1().setAttribut("currentNumberOfUploads", new Integer((Integer)edge3.getNode1().getAttribut("currentNumberOfUploads") - 1));
                File[] files = (File[])edge3.getNode2().getAttribut("ownedFiles");
                File[] newfiles = new File[files.length + 1];
                newfiles[0] = edge3.getFileToDownload();
                int n = 0;
                while (n < files.length) {
                    newfiles[n + 1] = files[n];
                    ++n;
                }
                edge3.getNode2().setAttribut("ownedFiles", newfiles);
                edge3.getNode2().setAttribut("numberOfFiles", new Integer(newfiles.length));
            }
            ++i2;
        }
    }

    public void addProtocol(Protocol p) {
        this.protocols.add(p);
    }

    public synchronized void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }
}

