/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.message;

import gnutellasim.graph.GnutellaNode;
import gnutellasim.message.Message;
import gnutellasim.message.MessageConstants;

public class PongMessage
extends Message {
    private String hostIp;
    private GnutellaNode sender;

    public PongMessage(short[] messageId, GnutellaNode n) {
        super(messageId);
        this.hostIp = n.getId() < 10 ? "192.168.1.00" + n.getId() : (n.getId() < 100 ? "192.168.1.0" + n.getId() : "192.168.1." + n.getId());
        this.sender = n;
    }

    public short functionID() {
        return (short)MessageConstants.PONG;
    }

    public long dataLength() {
        return 14L;
    }

    public int hostPort() {
        return 4711;
    }

    public String hostIp() {
        return this.hostIp;
    }

    public GnutellaNode getSender() {
        return this.sender;
    }

    public long fileCount() {
        return 0L;
    }

    public long totalSize() {
        return 0L;
    }

    public Object clone() {
        PongMessage res = new PongMessage(this.messageId(), this.getSender());
        res.setSource(this.getSource());
        res.setTarget(this.getTarget());
        return res;
    }
}

