/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.message;

import gnutellasim.graph.GnutellaNode;
import gnutellasim.message.Message;
import gnutellasim.message.MessageConstants;
import gnutellasim.util.File;
import java.util.Vector;

public class QueryHitMessage
extends Message {
    private Vector resultSet = new Vector();
    private GnutellaNode sender;

    public QueryHitMessage(short[] messageId, GnutellaNode sender) {
        super(messageId);
        this.sender = sender;
    }

    public QueryHitMessage(short ttl, short[] messageId, GnutellaNode sender) {
        super(ttl, messageId);
        this.sender = sender;
    }

    public short functionID() {
        return (short)MessageConstants.QUERYHIT;
    }

    public long dataLength() {
        return 11 + this.resultSetSize() + 16;
    }

    public Object clone() {
        QueryHitMessage res = new QueryHitMessage(this.ttlRemaining(), this.messageId(), this.getSender());
        res.setSource(this.getSource());
        res.setTarget(this.getTarget());
        int n = 0;
        while (n < this.resultSet.size()) {
            res.addResultSet((File)this.resultSet.get(n));
            ++n;
        }
        return res;
    }

    public GnutellaNode getSender() {
        return this.sender;
    }

    public void addResultSet(File result) {
        this.resultSet.add(result);
    }

    public File[] getResultSet() {
        return this.resultSet.toArray(new File[this.resultSet.size()]);
    }

    private int resultSetSize() {
        int res = 0;
        int i = 0;
        while (i < this.resultSet.size()) {
            res += 4;
            res += 4;
            res += ((File)this.resultSet.get(i)).getFileName().length() + 2;
            ++i;
        }
        return res;
    }
}

