/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.protocols;

import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.message.Message;
import gnutellasim.message.Network;
import gnutellasim.message.PingMessage;
import gnutellasim.message.PongMessage;
import gnutellasim.protocols.Protocol;
import gnutellasim.util.DefaultValues;

public class PingPong
extends Protocol {
    public void init(GnutellaNode n, int currentCycle) {
        n.setAttribut("lastPing", new Integer(currentCycle));
        int min = DefaultValues.minConnections();
        int max = DefaultValues.maxConnections();
        if (max < min) {
            max = min;
        }
        n.setAttribut("minConnections", new Integer(min));
        n.setAttribut("maxConnections", new Integer(max));
        n.setAttribut("pingFrequency", new Integer(DefaultValues.pingFrequency()));
        n.setAttribut("pingTtl", new Integer(DefaultValues.pingTtl()));
    }

    public void nextCycle(GnutellaNode n, int currentCycle) {
        int neighborscount = n.getNeighbors().length;
        if (n.isActive()) {
            int lastPing = (Integer)n.getAttribut("lastPing");
            if (neighborscount < (Integer)n.getAttribut("minConnections") && lastPing + (Integer)n.getAttribut("pingFrequency") < currentCycle) {
                PingMessage m = new PingMessage((short)((Integer)n.getAttribut("pingTtl")).intValue());
                this.sendAll(n, m);
                this.add(m, n, n);
                n.setAttribut("lastPing", new Integer(currentCycle));
            }
        }
        if (neighborscount > (Integer)n.getAttribut("maxConnections")) {
            GnutellaNode[] ns = n.getNeighbors();
            int i = 0;
            while (i < neighborscount - (Integer)n.getAttribut("maxConnections")) {
                n.removeNeighbor(ns[i]);
                ++i;
            }
        }
    }

    public boolean accept(Message m) {
        return m instanceof PingMessage || m instanceof PongMessage;
    }

    public void received(Message m, GnutellaNode n, GnutellaNode source) {
        if (m instanceof PingMessage) {
            if (this.unknown(m, n)) {
                this.add(m, n, source);
                m.increaseHop();
                PongMessage pong = new PongMessage(m.messageId(), n);
                Network.get().send(pong, n, source);
                if (m.ttlRemaining() > 0) {
                    this.sendAllExcept(n, m, source);
                }
            }
        } else if (m instanceof PongMessage) {
            GnutellaNode requestSource = this.getSource(m, n);
            if (requestSource != null && requestSource != n) {
                Network.get().send((Message)m.clone(), n, requestSource);
            }
            if (n.getNeighbors().length < (Integer)n.getAttribut("minConnections") && GnutellaGraph.getGraph().edgeConnecting(n, ((PongMessage)m).getSender()) == null && !((PongMessage)m).getSender().isDeath() && !n.isDeath() && n.isActive()) {
                GnutellaGraph.getGraph().addEdge(new RoutingEdge(), n, ((PongMessage)m).getSender());
            }
        }
    }
}

