/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.protocols;

import gnutellasim.graph.GnutellaNode;
import gnutellasim.message.Message;
import gnutellasim.message.Network;
import java.util.Hashtable;

public abstract class Protocol {
    private Hashtable ht = new Hashtable();

    public abstract void nextCycle(GnutellaNode var1, int var2);

    public abstract boolean accept(Message var1);

    public abstract void received(Message var1, GnutellaNode var2, GnutellaNode var3);

    public abstract void init(GnutellaNode var1, int var2);

    protected void sendAll(GnutellaNode n, Message msg) {
        GnutellaNode[] neighbors = n.getNeighbors();
        int i = 0;
        while (i < neighbors.length) {
            Network.get().send((Message)msg.clone(), n, neighbors[i]);
            ++i;
        }
    }

    protected void sendAllExcept(GnutellaNode n, Message msg, GnutellaNode except) {
        GnutellaNode[] neighbors = n.getNeighbors();
        int i = 0;
        while (i < neighbors.length) {
            if (neighbors[i] != except) {
                Network.get().send((Message)msg.clone(), n, neighbors[i]);
            }
            ++i;
        }
    }

    protected boolean unknown(Message m, GnutellaNode n) {
        return !this.ht.containsKey(String.valueOf(m.messageIdStr()) + n.getId());
    }

    protected void add(Message m, GnutellaNode n, GnutellaNode source) {
        this.ht.put(String.valueOf(m.messageIdStr()) + n.getId(), source);
    }

    protected GnutellaNode getSource(Message m, GnutellaNode n) {
        return (GnutellaNode)this.ht.get(String.valueOf(m.messageIdStr()) + n.getId());
    }
}

