/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.protocols;

import gnutellasim.graph.DownloadEdge;
import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.message.Message;
import gnutellasim.message.Network;
import gnutellasim.message.QueryHitMessage;
import gnutellasim.message.QueryMessage;
import gnutellasim.protocols.Protocol;
import gnutellasim.util.DefaultValues;
import gnutellasim.util.File;
import java.util.Vector;

public class QueryReplay
extends Protocol {
    public void init(GnutellaNode n, int currentCycle) {
        n.setAttribut("numberOfFiles", new Integer(DefaultValues.NumberOfFiles()));
        File[] files = new File[((Integer)n.getAttribut("numberOfFiles")).intValue()];
        int i = 0;
        while (i < files.length) {
            File file = File.getFile();
            while (this.has(files, file)) {
                file = File.getFile();
            }
            file.setFileIndex(i);
            files[i] = file;
            ++i;
        }
        n.setAttribut("ownedFiles", files);
        n.setAttribut("lastQuery", new Integer(currentCycle));
        n.setAttribut("queryTtl", new Integer(DefaultValues.queryTtl()));
        n.setAttribut("maxNumberOfDownloads", new Integer(DefaultValues.maxNumberOfDownloads()));
        n.setAttribut("currentNumberOfDownloads", new Integer(0));
        n.setAttribut("maxNumberOfUploads", new Integer(DefaultValues.maxNumberOfUploads()));
        n.setAttribut("currentNumberOfUploads", new Integer(0));
        n.setAttribut("queryFrequency", new Integer(DefaultValues.QueryFrequency()));
    }

    public void nextCycle(GnutellaNode n, int currentCycle) {
        int qfrq = (Integer)n.getAttribut("queryFrequency");
        if (currentCycle - (Integer)n.getAttribut("lastQuery") > qfrq && n.isActive()) {
            QueryMessage m = new QueryMessage((short)((Integer)n.getAttribut("queryTtl")).intValue(), File.getFile().getFileName());
            this.sendAll(n, m);
            this.add(m, n, n);
            n.setAttribut("lastQuery", new Integer(currentCycle));
        }
    }

    private boolean has(File[] files, File file) {
        int i = 0;
        while (i < files.length) {
            if (files[i] != null && files[i].getFileName().equalsIgnoreCase(file.getFileName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(Message m) {
        return m instanceof QueryMessage || m instanceof QueryHitMessage;
    }

    public void received(Message m, GnutellaNode n, GnutellaNode source) {
        QueryHitMessage qhm;
        if (m instanceof QueryMessage && this.unknown(m, n)) {
            QueryMessage qm;
            File[] searchResult;
            this.add(m, n, source);
            m.increaseHop();
            if (m.ttlRemaining() > 0) {
                this.sendAllExcept(n, m, source);
            }
            if ((searchResult = this.hasFile(n, (qm = (QueryMessage)m).getSearchString())).length > 0) {
                qhm = new QueryHitMessage(qm.messageId(), n);
                int i = 0;
                while (i < searchResult.length) {
                    qhm.addResultSet(searchResult[i]);
                    ++i;
                }
                Network.get().send(qhm, n, source);
            }
        }
        if (m instanceof QueryHitMessage) {
            GnutellaNode requestSource = this.getSource(m, n);
            if (requestSource != null && requestSource != n) {
                Network.get().send((Message)m.clone(), n, requestSource);
            }
            GnutellaNode sender = ((QueryHitMessage)m).getSender();
            if (requestSource == n && !sender.isDeath() && !n.isDeath() && (Integer)n.getAttribut("currentNumberOfDownloads") < (Integer)n.getAttribut("maxNumberOfDownloads") && (Integer)sender.getAttribut("currentNumberOfUploads") < (Integer)n.getAttribut("maxNumberOfUploads")) {
                qhm = (QueryHitMessage)m;
                File toDownload = null;
                int i = 0;
                while (i < qhm.getResultSet().length) {
                    File[] f = this.hasFile(n, qhm.getResultSet()[i].getFileName());
                    if (f.length == 0) {
                        toDownload = qhm.getResultSet()[i];
                    }
                    ++i;
                }
                if (toDownload != null) {
                    DownloadEdge e = new DownloadEdge(toDownload, DefaultValues.downloadEdgeCapacity());
                    GnutellaGraph.getGraph().addEdge(e, qhm.getSender(), n);
                    n.setAttribut("currentNumberOfDownloads", new Integer((Integer)n.getAttribut("currentNumberOfDownloads") + 1));
                    sender.setAttribut("currentNumberOfUploads", new Integer((Integer)sender.getAttribut("currentNumberOfUploads") + 1));
                }
            }
        }
    }

    private File[] hasFile(GnutellaNode n, String string) {
        Vector<File> res = new Vector<File>();
        File[] ownedFiles = (File[])n.getAttribut("ownedFiles");
        int i = 0;
        while (i < ownedFiles.length) {
            if (ownedFiles[i].getFileName().equalsIgnoreCase(string)) {
                res.add(ownedFiles[i]);
            }
            ++i;
        }
        return res.toArray(new File[res.size()]);
    }
}

