/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.simulation;

import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.message.Network;
import gnutellasim.protocols.Protocol;
import gnutellasim.statistics.EdgeStatisticCollector;
import gnutellasim.statistics.GlobalStatisticCollector;
import gnutellasim.statistics.NodeStatisticCollector;
import gnutellasim.util.DefaultValues;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import java.util.Vector;

public class Simulation
extends Thread {
    private GnutellaGraph graph;
    private Random rng;
    private boolean halt;
    private static int currentCycle;
    private static Vector protocol;
    private static Vector nodeStatisticCollector;
    private static Vector edgeStatisticCollector;
    private static Vector globalStatisticCollector;
    private static ActionListener listener;

    static {
        protocol = new Vector();
        nodeStatisticCollector = new Vector();
        edgeStatisticCollector = new Vector();
        globalStatisticCollector = new Vector();
    }

    public static void addProtocol(Protocol protocol) {
        Simulation.protocol.add(protocol);
        Network.get().addProtocol(protocol);
    }

    public static Protocol[] getProtocols() {
        return protocol.toArray(new Protocol[protocol.size()]);
    }

    public static void addNodeStatisticCollector(NodeStatisticCollector nsc) {
        nodeStatisticCollector.add(nsc);
    }

    public static NodeStatisticCollector[] getNodeStatisticCollectors() {
        return nodeStatisticCollector.toArray(new NodeStatisticCollector[nodeStatisticCollector.size()]);
    }

    public static void addEdgeStatisticCollector(EdgeStatisticCollector esc) {
        edgeStatisticCollector.add(esc);
    }

    public static EdgeStatisticCollector[] getEdgeStatisticCollectors() {
        return edgeStatisticCollector.toArray(new EdgeStatisticCollector[edgeStatisticCollector.size()]);
    }

    public static void addGlobalStatisticCollector(GlobalStatisticCollector gsc) {
        globalStatisticCollector.add(gsc);
    }

    public static GlobalStatisticCollector[] getGlobalStaticCollectors() {
        return globalStatisticCollector.toArray(new GlobalStatisticCollector[globalStatisticCollector.size()]);
    }

    public Simulation(int currentCycle, GnutellaGraph graph) {
        Simulation.currentCycle = currentCycle;
        this.halt = true;
        if (graph.getAttribut("lastAppear") == null) {
            graph.setAttribut("lastAppear", new Integer(0));
        }
        if (graph.getAttribut("lastDisappear") == null) {
            graph.setAttribut("lastDisappear", new Integer(0));
        }
        this.graph = graph;
        this.rng = new Random();
    }

    public void nextStep() {
        int lastAppear;
        int appearRate;
        int lastDisappear;
        GnutellaGraph g = GnutellaGraph.getGraph();
        int i = 0;
        while (i < g.getRootCount()) {
            Object root = g.getRootAt(i);
            if (root instanceof GnutellaNode) {
                GnutellaNode node = (GnutellaNode)root;
                int n = 0;
                while (n < nodeStatisticCollector.size()) {
                    ((NodeStatisticCollector)nodeStatisticCollector.get(n)).beforeStep(node, currentCycle);
                    ++n;
                }
            }
            ++i;
        }
        GlobalStatisticCollector[] gscs = Simulation.getGlobalStaticCollectors();
        int i2 = 0;
        while (i2 < gscs.length) {
            gscs[i2].beforeStep(g, currentCycle);
            ++i2;
        }
        Network.get().proceed();
        i2 = 0;
        while (i2 < g.getRootCount()) {
            Object root = g.getRootAt(i2);
            if (root instanceof GnutellaNode) {
                GnutellaNode node = (GnutellaNode)root;
                int n = 0;
                while (n < protocol.size()) {
                    ((Protocol)protocol.get(n)).nextCycle(node, currentCycle);
                    ++n;
                }
                n = 0;
                while (n < nodeStatisticCollector.size()) {
                    ((NodeStatisticCollector)nodeStatisticCollector.get(n)).afterStep(node, currentCycle);
                    ++n;
                }
            }
            ++i2;
        }
        gscs = Simulation.getGlobalStaticCollectors();
        i2 = 0;
        while (i2 < gscs.length) {
            gscs[i2].afterStep(g, currentCycle);
            ++i2;
        }
        int disappearRate = DefaultValues.getDisappearRate();
        if (disappearRate > 0 && currentCycle > (lastDisappear = ((Integer)this.graph.getAttribut("lastDisappear")).intValue()) + disappearRate) {
            GnutellaNode remove;
            GnutellaNode[] nodes = this.graph.getNodes();
            while ((remove = nodes[this.rng.nextInt(nodes.length)]).isDeath()) {
            }
            this.graph.removeNode(remove);
            this.graph.setAttribut("lastDisappear", new Integer(currentCycle));
        }
        if ((appearRate = DefaultValues.getAppearRate()) > 0 && currentCycle > (lastAppear = ((Integer)this.graph.getAttribut("lastAppear")).intValue()) + appearRate) {
            GnutellaNode to;
            GnutellaNode[] nodes = this.graph.getNodes();
            while ((to = nodes[this.rng.nextInt(nodes.length)]).isDeath()) {
            }
            GnutellaNode n = new GnutellaNode(this.rng.nextInt(600), this.rng.nextInt(450));
            this.graph.addNode(n);
            this.graph.addEdge(new RoutingEdge(), n, to);
            this.graph.setAttribut("lastAppear", new Integer(currentCycle));
        }
        ++currentCycle;
        if (listener != null) {
            listener.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void pause() {
        this.halt = true;
    }

    public boolean isPaused() {
        return this.halt;
    }

    public static int getCycle() {
        return currentCycle;
    }

    public void run() {
        this.halt = false;
        while (!this.halt) {
            this.nextStep();
        }
    }

    public static void setActionListener(ActionListener listener) {
        Simulation.listener = listener;
    }
}

