/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.statistics;

import gnutellasim.graph.GnutellaGraph;
import gnutellasim.graph.GnutellaNode;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.statistics.GlobalStatisticCollector;
import java.util.Vector;

public class GlobalAllStatisticCollector
implements GlobalStatisticCollector {
    public void init(GnutellaGraph graph, int currentCycle) {
        Vector v = new Vector();
        graph.setAttribut("bufferStatistic", v);
        v = new Vector();
        graph.setAttribut("nrOfConnections", v);
        v = new Vector();
        graph.setAttribut("messageSend", v);
        graph.setAttribut("messageSendTotal", new int[4]);
        graph.setAttribut("messageSendTotalB", new long[4]);
        graph.setAttribut("upDownStatistic", new Vector());
    }

    public void beforeStep(GnutellaGraph graph, int currentCycle) {
    }

    public void afterStep(GnutellaGraph graph, int currentCycle) {
        long bufferCapacity = 0L;
        long bufferFillLevel = 0L;
        int nrOfConnections = 0;
        int ping = 0;
        int pong = 0;
        int query = 0;
        int hit = 0;
        long pingB = 0L;
        long pongB = 0L;
        long queryB = 0L;
        long hitB = 0L;
        int nrOfNodes = 0;
        int nrOfDownloads = 0;
        int nrOfUploads = 0;
        int i = 0;
        while (i < graph.getRootCount()) {
            RoutingEdge re;
            Vector v;
            Object root = graph.getRootAt(i);
            if (root instanceof GnutellaNode && !((GnutellaNode)root).isDeath()) {
                GnutellaNode node = (GnutellaNode)root;
                bufferCapacity += (long)node.getMessageBuffer().getBufferSize();
                bufferFillLevel += (long)node.getMessageBuffer().getSize();
                nrOfConnections += node.getNeighbors().length;
                nrOfDownloads += ((Integer)node.getAttribut("currentNumberOfDownloads")).intValue();
                nrOfUploads += ((Integer)node.getAttribut("currentNumberOfUploads")).intValue();
                ++nrOfNodes;
            }
            if (root instanceof RoutingEdge && (v = (Vector)(re = (RoutingEdge)root).getAttribut("messagePassed")).size() > 0) {
                ping += ((Integer)v.get(v.size() - 8)).intValue();
                pong += ((Integer)v.get(v.size() - 7)).intValue();
                query += ((Integer)v.get(v.size() - 6)).intValue();
                hit += ((Integer)v.get(v.size() - 5)).intValue();
                pingB += ((Long)v.get(v.size() - 4)).longValue();
                pongB += ((Long)v.get(v.size() - 3)).longValue();
                queryB += ((Long)v.get(v.size() - 2)).longValue();
                hitB += ((Long)v.get(v.size() - 1)).longValue();
            }
            ++i;
        }
        Vector v = (Vector)graph.getAttribut("bufferStatistic");
        v.add(new Integer(currentCycle));
        v.add(new Long(bufferFillLevel));
        v.add(new Long(bufferCapacity));
        v = (Vector)graph.getAttribut("nrOfConnections");
        v.add(new Integer(currentCycle));
        v.add(new Integer(nrOfConnections /= 2));
        v = (Vector)graph.getAttribut("messageSend");
        v.add(new Integer(currentCycle));
        v.add(new Integer(ping));
        v.add(new Integer(pong));
        v.add(new Integer(query));
        v.add(new Integer(hit));
        v.add(new Long(pingB));
        v.add(new Long(pongB));
        v.add(new Long(queryB));
        v.add(new Long(hitB));
        int[] total = (int[])graph.getAttribut("messageSendTotal");
        total[0] = total[0] + ping;
        total[1] = total[1] + pong;
        total[2] = total[2] + query;
        total[3] = total[3] + hit;
        long[] totalB = (long[])graph.getAttribut("messageSendTotalB");
        totalB[0] = totalB[0] + pingB;
        totalB[1] = totalB[1] + pongB;
        totalB[2] = totalB[2] + queryB;
        totalB[3] = totalB[3] + hitB;
        v = (Vector)graph.getAttribut("upDownStatistic");
        v.add(new Integer(currentCycle));
        v.add(new Integer(nrOfDownloads));
        v.add(new Integer(nrOfUploads));
    }
}

