/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.statistics;

import gnutellasim.graph.GnutellaNode;
import gnutellasim.message.Message;
import gnutellasim.message.PingMessage;
import gnutellasim.message.PongMessage;
import gnutellasim.message.QueryHitMessage;
import gnutellasim.message.QueryMessage;
import gnutellasim.statistics.NodeStatisticCollector;
import gnutellasim.util.BoundedMessageBuffer;
import java.util.Vector;

public class PacketStatisticCollector
implements NodeStatisticCollector {
    public void init(GnutellaNode node, int currentCycle) {
        Vector v = new Vector();
        node.setAttribut("packetStatistic", v);
        int[] total = new int[4];
        node.setAttribut("packetTotalStatistic", total);
        long[] totalB = new long[4];
        node.setAttribut("packetTotalBStatistic", totalB);
    }

    public void beforeStep(GnutellaNode node, int currentCycle) {
        node.setAttribut("oldBuffer", node.getMessageBuffer().clone());
    }

    public void afterStep(GnutellaNode node, int currentCycle) {
        BoundedMessageBuffer oldbuffer = (BoundedMessageBuffer)node.getAttribut("oldBuffer");
        Vector v = (Vector)node.getAttribut("packetStatistic");
        int ping = 0;
        long pingB = 0L;
        int pong = 0;
        long pongB = 0L;
        int query = 0;
        long queryB = 0L;
        int hit = 0;
        long hitB = 0L;
        BoundedMessageBuffer b = node.getMessageBuffer();
        if (oldbuffer.getSize() > 0) {
            Message m;
            int i;
            if (b.getSize() == 0) {
                i = 0;
                while (i < oldbuffer.getSize()) {
                    m = oldbuffer.get(i);
                    if (m instanceof PingMessage) {
                        ++ping;
                        pingB += m.messageSizeInBytes();
                    } else if (m instanceof PongMessage) {
                        ++pong;
                        pongB += m.messageSizeInBytes();
                    } else if (m instanceof QueryMessage) {
                        ++query;
                        queryB += m.messageSizeInBytes();
                    } else if (m instanceof QueryHitMessage) {
                        ++hit;
                        hitB += m.messageSizeInBytes();
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < oldbuffer.getSize() && oldbuffer.get(i) != b.get(0)) {
                    m = oldbuffer.get(i);
                    if (m instanceof PingMessage) {
                        ++ping;
                        pingB += m.messageSizeInBytes();
                    } else if (m instanceof PongMessage) {
                        ++pong;
                        pongB += m.messageSizeInBytes();
                    } else if (m instanceof QueryMessage) {
                        ++query;
                        queryB += m.messageSizeInBytes();
                    } else if (m instanceof QueryHitMessage) {
                        ++hit;
                        hitB += m.messageSizeInBytes();
                    }
                    ++i;
                }
            }
        }
        v.add(new Integer(currentCycle));
        v.add(new Integer(ping));
        v.add(new Integer(pong));
        v.add(new Integer(query));
        v.add(new Integer(hit));
        int[] total = (int[])node.getAttribut("packetTotalStatistic");
        total[0] = total[0] + ping;
        total[1] = total[1] + pong;
        total[2] = total[2] + query;
        total[3] = total[3] + hit;
        node.setAttribut("packetTotalStatistic", total);
        long[] totalB = (long[])node.getAttribut("packetTotalBStatistic");
        totalB[0] = totalB[0] + pingB;
        totalB[1] = totalB[1] + pongB;
        totalB[2] = totalB[2] + queryB;
        totalB[3] = totalB[3] + hitB;
        node.setAttribut("packetTotalBStatistic", totalB);
    }
}

