/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.statistics;

import gnutellasim.graph.GnutellaEdge;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.message.Message;
import gnutellasim.message.PingMessage;
import gnutellasim.message.PongMessage;
import gnutellasim.message.QueryHitMessage;
import gnutellasim.message.QueryMessage;
import gnutellasim.statistics.EdgeStatisticCollector;
import java.util.Vector;

public class RoutingEdgeStatisticCollector
implements EdgeStatisticCollector {
    public void init(GnutellaEdge e, int currentCycle) {
        if (e instanceof RoutingEdge) {
            Vector v = new Vector();
            e.setAttribut("messagePassed", v);
            e.setAttribut("messagePassedTotal", new int[4]);
            e.setAttribut("messagePassedTotalB", new long[4]);
        }
    }

    public void collect(GnutellaEdge e, int currentCycle) {
        if (e instanceof RoutingEdge) {
            Vector v = (Vector)e.getAttribut("messagePassed");
            RoutingEdge re = (RoutingEdge)e;
            Message[] msg = re.getCurrentMessages();
            int ping = 0;
            int pong = 0;
            int query = 0;
            int hit = 0;
            long pingB = 0L;
            long pongB = 0L;
            long queryB = 0L;
            long hitB = 0L;
            int i = 0;
            while (i < msg.length) {
                if (msg[i] instanceof PingMessage) {
                    ++ping;
                    pingB += msg[i].messageSizeInBytes();
                }
                if (msg[i] instanceof PongMessage) {
                    ++pong;
                    pongB += msg[i].messageSizeInBytes();
                }
                if (msg[i] instanceof QueryMessage) {
                    ++query;
                    queryB += msg[i].messageSizeInBytes();
                }
                if (msg[i] instanceof QueryHitMessage) {
                    ++hit;
                    hitB += msg[i].messageSizeInBytes();
                }
                ++i;
            }
            v.add(new Integer(currentCycle));
            v.add(new Integer(ping));
            v.add(new Integer(pong));
            v.add(new Integer(query));
            v.add(new Integer(hit));
            v.add(new Long(pingB));
            v.add(new Long(pongB));
            v.add(new Long(queryB));
            v.add(new Long(hitB));
            int[] total = (int[])e.getAttribut("messagePassedTotal");
            total[0] = total[0] + ping;
            total[1] = total[1] + pong;
            total[2] = total[2] + query;
            total[3] = total[3] + hit;
            long[] totalB = (long[])e.getAttribut("messagePassedTotalB");
            totalB[0] = totalB[0] + pingB;
            totalB[1] = totalB[1] + pongB;
            totalB[2] = totalB[2] + queryB;
            totalB[3] = totalB[3] + hitB;
        }
    }
}

