/*
 * Decompiled with CFR 0.152.
 */
package gnutellasim.view;

import gnutellasim.graph.DownloadEdge;
import gnutellasim.graph.GnutellaEdge;
import gnutellasim.graph.RoutingEdge;
import gnutellasim.message.Message;
import gnutellasim.message.PingMessage;
import gnutellasim.message.PongMessage;
import gnutellasim.message.QueryHitMessage;
import gnutellasim.message.QueryMessage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;

public class GnutellaEdgeRenderer
extends EdgeRenderer {
    private int packsize = 10;

    public Rectangle2D getBounds(CellView value) {
        Rectangle2D r = super.getBounds(value);
        if (r != null) {
            double dif;
            int doublesize = this.packsize * 4;
            if (r.getWidth() < (double)doublesize) {
                dif = (double)doublesize - r.getWidth();
                r.setFrame(r.getX() - dif / 2.0, r.getY(), r.getWidth() + dif + 1.0, r.getHeight());
            }
            if (r.getHeight() < (double)doublesize) {
                dif = (double)doublesize - r.getHeight();
                r.setFrame(r.getX(), r.getY() - dif / 2.0, r.getWidth(), r.getHeight() + dif + 1.0);
            }
        }
        return r;
    }

    public void paint(Graphics g) {
        double heigth;
        double length;
        GnutellaEdge edge;
        if (this.view.getCell() instanceof DownloadEdge) {
            double y;
            double x;
            edge = (DownloadEdge)this.view.getCell();
            this.lineWidth = edge.getCapacity() / 64;
            this.lineDash = new float[]{10.0f, 10.0f};
            this.setForeground(Color.LIGHT_GRAY);
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            int c = 0;
            int j = 0;
            g2.setStroke(new BasicStroke(1.0f, c, j));
            PortView sourceView = (PortView)this.view.getSource();
            PortView targetView = (PortView)this.view.getTarget();
            Point2D sp = sourceView.getLocation(this.view);
            Point2D tp = targetView.getLocation(this.view);
            Port source = (Port)sourceView.getCell();
            length = tp.getX() - sp.getX();
            heigth = tp.getY() - sp.getY();
            double pos = (double)edge.getPercent() / 100.0;
            g.setColor(Color.DARK_GRAY);
            if (edge.getNode1().getPort() == source) {
                x = sp.getX() + pos * length - (double)(this.packsize / 2);
                y = sp.getY() + pos * heigth - (double)(this.packsize / 2);
                g.fillRect((int)x + 1, (int)y + 1, this.packsize - 1, this.packsize - 1);
                g.setColor(Color.BLACK);
                g.drawRect((int)x, (int)y, this.packsize, this.packsize);
            } else {
                x = tp.getX() - pos * length - (double)(this.packsize / 2);
                y = tp.getY() - pos * heigth - (double)(this.packsize / 2);
                g.fillRect((int)x + 1, (int)y + 1, this.packsize - 1, this.packsize - 1);
                g.setColor(Color.BLACK);
                g.drawRect((int)x, (int)y, this.packsize, this.packsize);
            }
        }
        if (this.view.getCell() instanceof RoutingEdge) {
            edge = (RoutingEdge)this.view.getCell();
            this.lineWidth = edge.getCapacity() / 10;
            super.paint(g);
            PortView sourceView = (PortView)this.view.getSource();
            if (sourceView == null) {
                return;
            }
            PortView targetView = (PortView)this.view.getTarget();
            if (targetView == null) {
                return;
            }
            Point2D sp = sourceView.getLocation(this.view);
            Point2D tp = targetView.getLocation(this.view);
            Port source = (Port)sourceView.getCell();
            if (this.view.lineShape != null) {
                Message[] msgs = ((RoutingEdge)edge).getCurrentMessages();
                int leftdoublecount = -(msgs.length / 2) - this.packsize / 2;
                int rightdoublecount = -(msgs.length / 2) - this.packsize / 2;
                length = tp.getX() - sp.getX();
                heigth = tp.getY() - sp.getY();
                int i = 0;
                while (i < msgs.length) {
                    if (msgs[i] != null) {
                        double y;
                        double x;
                        if (msgs[i] instanceof PingMessage) {
                            g.setColor(Color.RED);
                        } else if (msgs[i] instanceof PongMessage) {
                            g.setColor(Color.BLUE);
                        } else if (msgs[i] instanceof QueryMessage) {
                            g.setColor(Color.GREEN);
                        } else if (msgs[i] instanceof QueryHitMessage) {
                            g.setColor(Color.YELLOW);
                        } else {
                            g.setColor(Color.GRAY);
                        }
                        double pos = (double)msgs[i].getPercent() / 100.0;
                        if (msgs[i].getSource().getPort() == source) {
                            x = sp.getX() + pos * length + (double)rightdoublecount;
                            y = sp.getY() + pos * heigth + (double)rightdoublecount;
                            g.fillRect((int)x + 1, (int)y + 1, this.packsize - 1, this.packsize - 1);
                            g.setColor(Color.BLACK);
                            g.drawRect((int)x, (int)y, this.packsize, this.packsize);
                            rightdoublecount += 2;
                        } else {
                            x = tp.getX() - pos * length + (double)leftdoublecount;
                            y = tp.getY() - pos * heigth + (double)leftdoublecount;
                            g.fillRect((int)x + 1, (int)y + 1, this.packsize - 1, this.packsize - 1);
                            g.setColor(Color.BLACK);
                            g.drawRect((int)x, (int)y, this.packsize, this.packsize);
                            leftdoublecount += 2;
                        }
                    }
                    ++i;
                }
            }
        }
    }
}

