/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import org.jfree.base.BootableProjectInfo;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Log;

public abstract class AbstractBoot
implements SubSystem {
    private PackageManager singleton;
    private HierarchicalConfiguration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    public PackageManager getPackageManager() {
        if (this.singleton == null) {
            this.singleton = PackageManager.createInstance(this);
        }
        return this.singleton;
    }

    public ModifiableConfiguration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
            this.start();
        }
        return this.globalConfig;
    }

    public boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract HierarchicalConfiguration loadConfiguration();

    public final void start() {
        if (this.isBootInProgress() || this.isBootDone()) {
            return;
        }
        this.bootInProgress = true;
        BootableProjectInfo info = this.getProjectInfo();
        if (info != null) {
            Log.info(String.valueOf(info.getName()) + " " + info.getVersion());
            BootableProjectInfo[] childs = info.getDependencies();
            int i = 0;
            while (i < childs.length) {
                AbstractBoot boot = this.loadBooter(childs[i].getBootClass());
                if (boot != null) {
                    boot.start();
                }
                ++i;
            }
        }
        this.performBoot();
        this.bootInProgress = false;
        this.bootDone = true;
    }

    protected abstract void performBoot();

    protected abstract BootableProjectInfo getProjectInfo();

    protected AbstractBoot loadBooter(String classname) {
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass(classname);
            return (AbstractBoot)c.newInstance();
        }
        catch (Exception e) {
            Log.info("Unable to boot dependent class: " + classname);
            return null;
        }
    }
}

