/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.jfree.base.config.ModifiableConfiguration;

public class HierarchicalConfiguration
implements ModifiableConfiguration {
    private Properties configuration = new Properties();
    private transient ModifiableConfiguration parentConfiguration;

    public HierarchicalConfiguration() {
    }

    public HierarchicalConfiguration(ModifiableConfiguration parentConfiguration) {
        this();
        this.parentConfiguration = parentConfiguration;
    }

    public String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    public String getConfigProperty(String key, String defaultValue) {
        String value = this.configuration.getProperty(key);
        if (value == null) {
            value = this.isRootConfig() ? defaultValue : this.parentConfiguration.getConfigProperty(key, defaultValue);
        }
        return value;
    }

    public void setConfigProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.configuration.remove(key);
        } else {
            this.configuration.setProperty(key, value);
        }
    }

    private boolean isRootConfig() {
        return this.parentConfiguration == null;
    }

    public boolean isLocallyDefined(String key) {
        return this.configuration.containsKey(key);
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    public void insertConfiguration(HierarchicalConfiguration config) {
        config.setParentConfig(this.getParentConfig());
        this.setParentConfig(config);
    }

    protected void setParentConfig(ModifiableConfiguration config) {
        if (this.parentConfiguration == this) {
            throw new IllegalArgumentException("Cannot add myself as parent configuration.");
        }
        this.parentConfiguration = config;
    }

    protected ModifiableConfiguration getParentConfig() {
        return this.parentConfiguration;
    }

    public Enumeration getConfigProperties() {
        return this.configuration.keys();
    }

    public Iterator findPropertyKeys(String prefix) {
        TreeSet keys = new TreeSet();
        this.collectPropertyKeys(prefix, this, keys);
        return Collections.unmodifiableSet(keys).iterator();
    }

    private void collectPropertyKeys(String prefix, ModifiableConfiguration config, TreeSet collector) {
        Enumeration enumeration = config.getConfigProperties();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(prefix) || collector.contains(key)) continue;
            collector.add(key);
        }
        if (config instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration hconfig = (HierarchicalConfiguration)config;
            if (hconfig.parentConfiguration != null) {
                this.collectPropertyKeys(prefix, hconfig.parentConfiguration, collector);
            }
        }
    }
}

