/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;

public class CategoryTextAnnotationTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.annotations.junit.CategoryTextAnnotationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CategoryTextAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setCategory((Comparable)((Object)"Category 2"));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setCategory((Comparable)((Object)"Category 2"));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryAnchor(CategoryAnchor.START);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryAnchor(CategoryAnchor.START);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setValue(0.15);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setValue(0.15);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = null;
        try {
            a2 = (CategoryTextAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("CategoryAnnotationTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CategoryTextAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }
}

