/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.annotations.XYDrawableAnnotation;

public class XYDrawableAnnotationTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.annotations.junit.XYDrawableAnnotationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public XYDrawableAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYDrawableAnnotation a1 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, null);
        XYDrawableAnnotation a2 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, null);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        XYDrawableAnnotation a1 = new XYDrawableAnnotation(10.0, 20.0, 100.0, 200.0, null);
        XYDrawableAnnotation a2 = null;
        try {
            a2 = (XYDrawableAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("XYDrawableAnnotationTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        CategoryTextAnnotation a1 = new CategoryTextAnnotation("Test", (Comparable)((Object)"Category"), 1.0);
        CategoryTextAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CategoryTextAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }
}

