/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYLineAnnotation;

public class XYLineAnnotationTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.annotations.junit.XYLineAnnotationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public XYLineAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        BasicStroke stroke = new BasicStroke(2.0f);
        XYLineAnnotation a1 = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, stroke, Color.blue);
        XYLineAnnotation a2 = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, stroke, Color.blue);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        BasicStroke stroke = new BasicStroke(2.0f);
        XYLineAnnotation a1 = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, stroke, Color.blue);
        XYLineAnnotation a2 = null;
        try {
            a2 = (XYLineAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("XYLineAnnotationTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        BasicStroke stroke = new BasicStroke(2.0f);
        XYLineAnnotation a1 = new XYLineAnnotation(10.0, 20.0, 100.0, 200.0, stroke, Color.blue);
        XYLineAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYLineAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }
}

