/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYPointerAnnotation;

public class XYPointerAnnotationTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.annotations.junit.XYPointerAnnotationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public XYPointerAnnotationTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYPointerAnnotation a1 = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation a2 = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAngle(0.7853981633974483);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAngle(0.7853981633974483);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setTipRadius(20.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setTipRadius(20.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setBaseRadius(5.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setBaseRadius(5.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setArrowLength(33.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setArrowLength(33.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setArrowWidth(9.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setArrowWidth(9.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        BasicStroke stroke = new BasicStroke(1.5f);
        a1.setArrowStroke(stroke);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setArrowStroke(stroke);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setArrowPaint(Color.blue);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setArrowPaint(Color.blue);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setLabelOffset(10.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setLabelOffset(10.0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        XYPointerAnnotation a1 = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation a2 = null;
        try {
            a2 = (XYPointerAnnotation)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("XYPointerAnnotationTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        XYPointerAnnotation a1 = new XYPointerAnnotation("Label", 10.0, 20.0, Math.PI);
        XYPointerAnnotation a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (XYPointerAnnotation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }
}

