/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class AxisSpace
implements Cloneable,
PublicCloneable,
Serializable {
    private double top = 0.0;
    private double bottom = 0.0;
    private double left = 0.0;
    private double right = 0.0;

    public double getTop() {
        return this.top;
    }

    public void setTop(double space) {
        this.top = space;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double space) {
        this.bottom = space;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double space) {
        this.left = space;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double space) {
        this.right = space;
    }

    public void add(double space, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            this.top += space;
        } else if (edge == RectangleEdge.BOTTOM) {
            this.bottom += space;
        } else if (edge == RectangleEdge.LEFT) {
            this.left += space;
        } else if (edge == RectangleEdge.RIGHT) {
            this.right += space;
        } else {
            throw new IllegalStateException("AxisSpace.add(...): unrecognised RectangleEdge.");
        }
    }

    public void ensureAtLeast(AxisSpace space) {
        this.top = Math.max(this.top, space.top);
        this.bottom = Math.max(this.bottom, space.bottom);
        this.left = Math.max(this.left, space.left);
        this.right = Math.max(this.right, space.right);
    }

    public void ensureAtLeast(double space, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            if (this.top < space) {
                this.top = space;
            }
        } else if (edge == RectangleEdge.BOTTOM) {
            if (this.bottom < space) {
                this.bottom = space;
            }
        } else if (edge == RectangleEdge.LEFT) {
            if (this.left < space) {
                this.left = space;
            }
        } else if (edge == RectangleEdge.RIGHT) {
            if (this.right < space) {
                this.right = space;
            }
        } else {
            throw new IllegalStateException("AxisSpace.ensureAtLeast(...): unrecognised AxisLocation.");
        }
    }

    public Rectangle2D shrink(Rectangle2D area, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(area.getX() + this.left, area.getY() + this.top, area.getWidth() - this.left - this.right, area.getHeight() - this.top - this.bottom);
        return result;
    }

    public Rectangle2D shrinkLeftAndRight(Rectangle2D area, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(area.getX() + this.left, area.getY(), area.getWidth() - this.left - this.right, area.getHeight());
        return result;
    }

    public Rectangle2D shrinkTopAndBottom(Rectangle2D area, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(area.getX(), area.getY() + this.top, area.getWidth(), area.getHeight() - this.top - this.bottom);
        return result;
    }

    public Rectangle2D expand(Rectangle2D area, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(area.getX() - this.left, area.getY() - this.top, area.getWidth() + this.left + this.right, area.getHeight() + this.top + this.bottom);
        return result;
    }

    public Rectangle2D reserved(Rectangle2D area, RectangleEdge edge) {
        Rectangle2D.Double result = null;
        if (edge == RectangleEdge.TOP) {
            result = new Rectangle2D.Double(area.getX(), area.getY(), area.getWidth(), this.top);
        } else if (edge == RectangleEdge.BOTTOM) {
            result = new Rectangle2D.Double(area.getX(), area.getMaxY() - this.top, area.getWidth(), this.bottom);
        } else if (edge == RectangleEdge.LEFT) {
            result = new Rectangle2D.Double(area.getX(), area.getY(), this.left, area.getHeight());
        } else if (edge == RectangleEdge.RIGHT) {
            result = new Rectangle2D.Double(area.getMaxX() - this.right, area.getY(), this.right, area.getHeight());
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AxisSpace) {
            boolean b3;
            AxisSpace s = (AxisSpace)object;
            boolean b0 = this.top == s.top;
            boolean b1 = this.bottom == s.bottom;
            boolean b2 = this.left == s.left;
            boolean bl = b3 = this.right == s.right;
            return b0 && b1 && b2 && b3;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[left=" + this.left + ",right=" + this.right + ",top=" + this.top + ",bottom=" + this.bottom + "]";
    }
}

