/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public class PeriodAxis
extends ValueAxis
implements Cloneable,
Serializable {
    private RegularTimePeriod first;
    private RegularTimePeriod last;
    private TimeZone timeZone;
    private Class autoRangeTimePeriodClass;
    private PeriodAxisLabelInfo[] labelInfo;
    private static final LogContext LOGGER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.PeriodAxis");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext(clazz);
    }

    public PeriodAxis(String label) {
        this(label, new Day(), new Day());
    }

    public PeriodAxis(String label, RegularTimePeriod first, RegularTimePeriod last) {
        this(label, first, last, TimeZone.getDefault());
    }

    public PeriodAxis(String label, RegularTimePeriod first, RegularTimePeriod last, TimeZone timeZone) {
        super(label, null);
        this.first = first;
        this.last = last;
        this.timeZone = timeZone;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Day");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.autoRangeTimePeriodClass = clazz;
        this.setAutoRange(true);
        this.labelInfo = new PeriodAxisLabelInfo[2];
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.jfree.data.time.Month");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.labelInfo[0] = new PeriodAxisLabelInfo(clazz2, "MMM");
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.jfree.data.time.Year");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.labelInfo[1] = new PeriodAxisLabelInfo(clazz3, "yyyy");
    }

    public RegularTimePeriod getFirst() {
        return this.first;
    }

    public void setFirst(RegularTimePeriod first) {
        if (first == null) {
            throw new IllegalArgumentException("Null 'first' argument.");
        }
        this.first = first;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public RegularTimePeriod getLast() {
        return this.last;
    }

    public void setLast(RegularTimePeriod last) {
        if (last == null) {
            throw new IllegalArgumentException("Null 'last' argument.");
        }
        this.last = last;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone zone) {
        if (zone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        this.timeZone = zone;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Class getAutoRangeTimePeriodClass() {
        return this.autoRangeTimePeriodClass;
    }

    public void setAutoRangeTimePeriodClass(Class c) {
        if (c == null) {
            throw new IllegalArgumentException("Null 'c' argument.");
        }
        this.autoRangeTimePeriodClass = c;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public PeriodAxisLabelInfo[] getLabelInfo() {
        return this.labelInfo;
    }

    public void setLabelInfo(PeriodAxisLabelInfo[] info) {
        this.labelInfo = info;
    }

    public Range getRange() {
        return new Range(this.first.getFirstMillisecond(this.timeZone), this.last.getLastMillisecond(this.timeZone));
    }

    public void configure() {
        this.autoAdjustRange();
    }

    public AxisSpace reserveSpace(Graphics2D g2, Plot plot, Rectangle2D plotArea, RectangleEdge edge, AxisSpace space) {
        if (space == null) {
            space = new AxisSpace();
        }
        if (!this.isVisible()) {
            return space;
        }
        double dimension = this.getFixedDimension();
        if (dimension > 0.0) {
            space.ensureAtLeast(dimension, edge);
        }
        Rectangle2D labelEnclosure = this.getLabelEnclosure(g2, edge);
        double labelHeight = 0.0;
        double labelWidth = 0.0;
        double tickLabelBandsDimension = 0.0;
        int i = 0;
        while (i < this.labelInfo.length) {
            PeriodAxisLabelInfo info = this.labelInfo[i];
            FontMetrics fm = g2.getFontMetrics(info.getLabelFont());
            tickLabelBandsDimension += info.getSpacer().getAdjustedHeight(fm.getHeight());
            ++i;
        }
        if (RectangleEdge.isTopOrBottom(edge)) {
            labelHeight = labelEnclosure.getHeight();
            space.add(labelHeight + tickLabelBandsDimension, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            labelWidth = labelEnclosure.getWidth();
            space.add(labelWidth + tickLabelBandsDimension, edge);
        }
        return space;
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        LOGGER.debug("In draw() method (cursor = " + cursor + ")");
        AxisState axisState = new AxisState(cursor);
        this.drawAxisLine(g2, cursor, dataArea, edge);
        int band = 0;
        while (band < this.labelInfo.length) {
            axisState = this.drawTickLabels(band, g2, axisState, dataArea, edge);
            ++band;
        }
        axisState = this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, axisState);
        return axisState;
    }

    protected AxisState drawTickLabels(int band, Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        double delta1 = 0.0;
        FontMetrics fm = g2.getFontMetrics(this.labelInfo[band].getLabelFont());
        if (edge == RectangleEdge.BOTTOM) {
            delta1 = this.labelInfo[band].getSpacer().getTopSpace(fm.getHeight());
        } else if (edge == RectangleEdge.TOP) {
            delta1 = this.labelInfo[band].getSpacer().getBottomSpace(fm.getHeight());
        }
        state.moveCursor(delta1, edge);
        long axisMin = this.first.getFirstMillisecond(this.timeZone);
        long axisMax = this.last.getLastMillisecond(this.timeZone);
        g2.setFont(this.labelInfo[band].getLabelFont());
        g2.setPaint(this.labelInfo[band].getLabelPaint());
        RegularTimePeriod p1 = this.labelInfo[band].createInstance(new Date(axisMin), this.timeZone);
        RegularTimePeriod p2 = this.labelInfo[band].createInstance(new Date(axisMax), this.timeZone);
        String label1 = this.labelInfo[band].getDateFormat().format(new Date(p1.getMiddleMillisecond(this.timeZone)));
        String label2 = this.labelInfo[band].getDateFormat().format(new Date(p2.getMiddleMillisecond(this.timeZone)));
        Rectangle2D b1 = TextUtilities.getTextBounds(label1, g2, g2.getFontMetrics());
        Rectangle2D b2 = TextUtilities.getTextBounds(label2, g2, g2.getFontMetrics());
        double w = Math.max(b1.getWidth(), b2.getWidth());
        long ww = Math.round(this.java2DToValue(dataArea.getX() + w + 5.0, dataArea, edge)) - axisMin;
        long length = p1.getLastMillisecond(this.timeZone) - p1.getFirstMillisecond(this.timeZone);
        int periods = (int)(ww / length) + 1;
        RegularTimePeriod p = this.labelInfo[band].createInstance(new Date(axisMin), this.timeZone);
        RectangularShape b = null;
        long lastXX = 0L;
        float y = (float)state.getCursor();
        TextAnchor anchor = TextAnchor.TOP_CENTER;
        if (edge == RectangleEdge.TOP) {
            anchor = TextAnchor.BOTTOM_CENTER;
        }
        while (p.getFirstMillisecond(this.timeZone) <= axisMax) {
            Rectangle2D bb;
            float x = (float)this.valueToJava2D(p.getMiddleMillisecond(this.timeZone), dataArea, edge);
            DateFormat df = this.labelInfo[band].getDateFormat();
            String label = df.format(new Date(p.getMiddleMillisecond(this.timeZone)));
            long first = p.getFirstMillisecond(this.timeZone);
            long last = p.getLastMillisecond(this.timeZone);
            if (last > axisMax && (double)x + (bb = TextUtilities.getTextBounds(label, g2, g2.getFontMetrics())).getWidth() / 2.0 > dataArea.getMaxX()) {
                float xstart = (float)this.valueToJava2D(Math.max(first, axisMin), dataArea, edge);
                if (bb.getWidth() < dataArea.getMaxX() - (double)xstart) {
                    x = ((float)dataArea.getMaxX() + xstart) / 2.0f;
                } else {
                    label = null;
                }
            }
            if (first < axisMin && (double)x - (bb = TextUtilities.getTextBounds(label, g2, g2.getFontMetrics())).getWidth() / 2.0 < dataArea.getX()) {
                float xlast = (float)this.valueToJava2D(Math.min(last, axisMax), dataArea, edge);
                if (bb.getWidth() < (double)xlast - dataArea.getX()) {
                    x = (xlast + (float)dataArea.getX()) / 2.0f;
                } else {
                    label = null;
                }
            }
            if (label != null) {
                g2.setPaint(this.labelInfo[band].getLabelPaint());
                b = TextUtilities.drawAlignedString(label, g2, x, y, anchor);
            }
            if (lastXX > 0L && this.labelInfo[band].getDrawDividers()) {
                long nextXX = p.getFirstMillisecond(this.timeZone);
                long mid = (lastXX + nextXX) / 2L;
                float mid2d = (float)this.valueToJava2D(mid, dataArea, edge);
                g2.setStroke(this.labelInfo[band].getDividerStroke());
                g2.setPaint(this.labelInfo[band].getDividerPaint());
                g2.draw(new Line2D.Float(mid2d, y, mid2d, y + (float)b1.getHeight()));
            }
            lastXX = last;
            int i = 0;
            while (i < periods) {
                p = p.next();
                ++i;
            }
        }
        double used = 0.0;
        if (b != null) {
            used = b.getHeight();
            if (edge == RectangleEdge.BOTTOM) {
                used += this.labelInfo[band].getSpacer().getBottomSpace(fm.getHeight());
            } else if (edge == RectangleEdge.TOP) {
                used += this.labelInfo[band].getSpacer().getTopSpace(fm.getHeight());
            }
        }
        state.moveCursor(used, edge);
        return state;
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        return new ArrayList();
    }

    public double valueToJava2D(double value, Rectangle2D area, RectangleEdge edge) {
        double result = Double.NaN;
        double axisMin = this.first.getFirstMillisecond(this.timeZone);
        double axisMax = this.last.getLastMillisecond(this.timeZone);
        if (RectangleEdge.isTopOrBottom(edge)) {
            double minX = area.getX();
            double maxX = area.getMaxX();
            result = this.isInverted() ? maxX + (value - axisMin) / (axisMax - axisMin) * (minX - maxX) : minX + (value - axisMin) / (axisMax - axisMin) * (maxX - minX);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            double minY = area.getMinY();
            double maxY = area.getMaxY();
            result = this.isInverted() ? minY + (value - axisMin) / (axisMax - axisMin) * (maxY - minY) : maxY - (value - axisMin) / (axisMax - axisMin) * (maxY - minY);
        }
        return result;
    }

    public double java2DToValue(double java2DValue, Rectangle2D area, RectangleEdge edge) {
        double result = Double.NaN;
        double min = 0.0;
        double max = 0.0;
        double axisMin = this.first.getFirstMillisecond(this.timeZone);
        double axisMax = this.last.getLastMillisecond(this.timeZone);
        if (RectangleEdge.isTopOrBottom(edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            min = area.getMaxY();
            max = area.getY();
        }
        result = this.isInverted() ? axisMax - (java2DValue - min) / (max - min) * (axisMax - axisMin) : axisMin + (java2DValue - min) / (max - min) * (axisMax - axisMin);
        return result;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot vap = (ValueAxisPlot)((Object)plot);
            Range r = vap.getDataRange(this);
            if (r == null) {
                r = new Range(0.0, 1.0);
            }
            long upper = Math.round(r.getUpperBound());
            long lower = Math.round(r.getLowerBound());
            this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(lower), this.timeZone);
            this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(upper), this.timeZone);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PeriodAxis) {
            PeriodAxis a = (PeriodAxis)obj;
            if (!this.first.equals(a.first)) {
                return false;
            }
            if (!this.last.equals(a.last)) {
                return false;
            }
            if (!this.timeZone.equals(a.timeZone)) {
                return false;
            }
            if (!this.autoRangeTimePeriodClass.equals(a.autoRangeTimePeriodClass)) {
                return false;
            }
            return Arrays.equals(this.labelInfo, a.labelInfo);
        }
        return false;
    }

    private RegularTimePeriod createInstance(Class periodClass, Date millisecond, TimeZone zone) {
        RegularTimePeriod result = null;
        try {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("java.util.TimeZone");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Constructor c = periodClass.getDeclaredConstructor(classArray);
            result = (RegularTimePeriod)c.newInstance(millisecond, zone);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

