/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;

public class AxisTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.AxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public AxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        CategoryAxis a1 = new CategoryAxis("Test");
        a1.setAxisLinePaint(Color.red);
        CategoryAxis a2 = null;
        try {
            a2 = (CategoryAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("CategoryAxisTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testEquals() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = new CategoryAxis("Test");
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setVisible(false);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setVisible(false);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabel("New Label");
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabel("New Label");
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelFont(new Font("Dialog", 0, 8));
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelFont(new Font("Dialog", 0, 8));
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelPaint(Color.blue);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelPaint(Color.blue);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelInsets(new Insets(10, 10, 10, 10));
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelInsets(new Insets(10, 10, 10, 10));
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setLabelAngle(1.23);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setLabelAngle(1.23);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setAxisLineVisible(false);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setAxisLineVisible(false);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        BasicStroke s = new BasicStroke(1.1f);
        a1.setAxisLineStroke(s);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setAxisLineStroke(s);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setAxisLinePaint(Color.blue);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setAxisLinePaint(Color.blue);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelsVisible(false);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelsVisible(false);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelFont(new Font("Dialog", 0, 12));
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelFont(new Font("Dialog", 0, 12));
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelPaint(Color.red);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelPaint(Color.red);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickLabelInsets(new Insets(10, 10, 10, 10));
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickLabelInsets(new Insets(10, 10, 10, 10));
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarksVisible(true);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarksVisible(true);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkInsideLength(1.23f);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkInsideLength(1.23f);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkOutsideLength(1.23f);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkOutsideLength(1.23f);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkStroke(new BasicStroke(2.0f));
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkStroke(new BasicStroke(2.0f));
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setTickMarkPaint(Color.green);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setTickMarkPaint(Color.green);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
        a1.setFixedDimension(3.21f);
        Assert.assertFalse((boolean)((Axis)a1).equals(a2));
        a2.setFixedDimension(3.21f);
        Assert.assertTrue((boolean)((Axis)a1).equals(a2));
    }
}

