/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;

public class CategoryAxisTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.CategoryAxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CategoryAxisTests(String name) {
        super(name);
    }

    public void testEquals() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = new CategoryAxis("Test");
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setLowerMargin(0.15);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setLowerMargin(0.15);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setUpperMargin(0.15);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setUpperMargin(0.15);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryMargin(0.15);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryMargin(0.15);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setMaxCategoryLabelWidthRatio(0.98f);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setMaxCategoryLabelWidthRatio(0.98f);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryLabelPositionOffset(11);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryLabelPositionOffset(11);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.addCategoryLabelToolTip((Comparable)((Object)"Test"), "Check");
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.addCategoryLabelToolTip((Comparable)((Object)"Test"), "Check");
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        CategoryAxis a1 = new CategoryAxis("Test");
        CategoryAxis a2 = null;
        try {
            a2 = (CategoryAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        CategoryAxis a1 = new CategoryAxis("Test Axis");
        CategoryAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CategoryAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }
}

