/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextLine;
import org.jfree.ui.TextAnchor;

public class CategoryTickTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.CategoryTickTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CategoryTickTests(String name) {
        super(name);
    }

    public void testEquals() {
        String c1 = "C1";
        String c2 = "C2";
        TextBlock tb1 = new TextBlock();
        tb1.addLine(new TextLine("Block 1"));
        TextBlock tb2 = new TextBlock();
        tb1.addLine(new TextLine("Block 2"));
        TextBlockAnchor tba1 = TextBlockAnchor.CENTER;
        TextBlockAnchor tba2 = TextBlockAnchor.BOTTOM_CENTER;
        TextAnchor ta1 = TextAnchor.CENTER;
        TextAnchor ta2 = TextAnchor.BASELINE_LEFT;
        CategoryTick t1 = new CategoryTick((Comparable)((Object)c1), tb1, tba1, ta1, 1.0);
        CategoryTick t2 = new CategoryTick((Comparable)((Object)c1), tb1, tba1, ta1, 1.0);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1 = new CategoryTick((Comparable)((Object)c2), tb1, tba1, ta1, 1.0);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2 = new CategoryTick((Comparable)((Object)c2), tb1, tba1, ta1, 1.0);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1 = new CategoryTick((Comparable)((Object)c2), tb2, tba1, ta1, 1.0);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2 = new CategoryTick((Comparable)((Object)c2), tb2, tba1, ta1, 1.0);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1 = new CategoryTick((Comparable)((Object)c2), tb2, tba2, ta1, 1.0);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2 = new CategoryTick((Comparable)((Object)c2), tb2, tba2, ta1, 1.0);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1 = new CategoryTick((Comparable)((Object)c2), tb2, tba2, ta2, 1.0);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2 = new CategoryTick((Comparable)((Object)c2), tb2, tba2, ta2, 1.0);
        Assert.assertTrue((boolean)t1.equals(t2));
        t1 = new CategoryTick((Comparable)((Object)c2), tb2, tba2, ta2, 2.0);
        Assert.assertFalse((boolean)t1.equals(t2));
        t2 = new CategoryTick((Comparable)((Object)c2), tb2, tba2, ta2, 2.0);
        Assert.assertTrue((boolean)t1.equals(t2));
    }

    public void testCloning() {
        CategoryTick t1 = new CategoryTick((Comparable)((Object)"C1"), new TextBlock(), TextBlockAnchor.CENTER, TextAnchor.CENTER, 1.5);
        CategoryTick t2 = null;
        try {
            t2 = (CategoryTick)t1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((t1 != t2 ? 1 : 0) != 0);
        Assert.assertTrue((t1.getClass() == t2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)t1.equals(t2));
    }

    public void testSerialization() {
        CategoryTick t1 = new CategoryTick((Comparable)((Object)"C1"), new TextBlock(), TextBlockAnchor.CENTER, TextAnchor.CENTER, 1.5);
        CategoryTick t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (CategoryTick)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)t1, t2);
    }
}

