/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.junit.NumberAxisTests;

public class CyclicNumberAxisTests
extends NumberAxisTests {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.CyclicNumberAxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public CyclicNumberAxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis a2 = null;
        try {
            a2 = (CyclicNumberAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("ValueAxisTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testEquals() {
        super.testEquals();
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test");
        CyclicNumberAxis a2 = new CyclicNumberAxis(10.0, 0.0, "Test");
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setPeriod(5.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setPeriod(5.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setOffset(2.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setOffset(2.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAdvanceLinePaint(Color.cyan);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAdvanceLinePaint(Color.cyan);
        Assert.assertTrue((boolean)a1.equals(a2));
        BasicStroke stroke = new BasicStroke(0.2f);
        a1.setAdvanceLineStroke(stroke);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAdvanceLineStroke(stroke);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAdvanceLineVisible(!a1.isAdvanceLineVisible());
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAdvanceLineVisible(a1.isAdvanceLineVisible());
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setBoundMappedToLastCycle(!a1.isBoundMappedToLastCycle());
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setBoundMappedToLastCycle(a1.isBoundMappedToLastCycle());
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        CyclicNumberAxis a1 = new CyclicNumberAxis(10.0, 0.0, "Test Axis");
        CyclicNumberAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (CyclicNumberAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }
}

