/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.data.DateRange;
import org.jfree.ui.RectangleEdge;

public class DateAxisTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.DateAxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DateAxisTests(String name) {
        super(name);
    }

    public void testEquals() {
        DateAxis a1 = new DateAxis("Test");
        DateAxis a2 = new DateAxis("Test");
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setTickUnit(new DateTickUnit(2, 7));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setTickUnit(new DateTickUnit(2, 7));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setDateFormatOverride(new SimpleDateFormat("yyyy"));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setDateFormatOverride(new SimpleDateFormat("yyyy"));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setTickMarkPosition(DateTickMarkPosition.END);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setTickMarkPosition(DateTickMarkPosition.END);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        DateAxis a1 = new DateAxis("Test");
        DateAxis a2 = null;
        try {
            a2 = (DateAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("DateAxisTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSetRange() {
        DateAxis axis = new DateAxis("Test Axis");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1999, 0, 3);
        Date d1 = calendar.getTime();
        calendar.set(1999, 0, 31);
        Date d2 = calendar.getTime();
        axis.setRange(d1, d2);
        DateRange range = (DateRange)axis.getRange();
        Assert.assertEquals((Object)d1, (Object)range.getLowerDate());
        Assert.assertEquals((Object)d2, (Object)range.getUpperDate());
    }

    public void testSetMaximumDate() {
        DateAxis axis = new DateAxis("Test Axis");
        Date date = new Date();
        axis.setMaximumDate(date);
        Assert.assertEquals((Object)date, (Object)axis.getMaximumDate());
    }

    public void testSetMinimumDate() {
        DateAxis axis = new DateAxis("Test Axis");
        Date d1 = new Date();
        Date d2 = new Date(d1.getTime() + 1L);
        axis.setMaximumDate(d2);
        axis.setMinimumDate(d1);
        Assert.assertEquals((Object)d1, (Object)axis.getMinimumDate());
    }

    private boolean same(double d1, double d2, double tolerance) {
        return Math.abs(d1 - d2) < tolerance;
    }

    public void testJava2DToValue() {
        DateAxis axis = new DateAxis();
        axis.setRange(50.0, 100.0);
        Rectangle2D.Double dataArea = new Rectangle2D.Double(10.0, 50.0, 400.0, 300.0);
        double y1 = axis.java2DToValue(75.0, dataArea, RectangleEdge.LEFT);
        Assert.assertTrue((boolean)this.same(y1, 95.8333333, 1.0));
        double y2 = axis.java2DToValue(75.0, dataArea, RectangleEdge.RIGHT);
        Assert.assertTrue((boolean)this.same(y2, 95.8333333, 1.0));
        double x1 = axis.java2DToValue(75.0, dataArea, RectangleEdge.TOP);
        Assert.assertTrue((boolean)this.same(x1, 58.125, 1.0));
        double x2 = axis.java2DToValue(75.0, dataArea, RectangleEdge.BOTTOM);
        Assert.assertTrue((boolean)this.same(x2, 58.125, 1.0));
        axis.setInverted(true);
        double y3 = axis.java2DToValue(75.0, dataArea, RectangleEdge.LEFT);
        Assert.assertTrue((boolean)this.same(y3, 54.1666667, 1.0));
        double y4 = axis.java2DToValue(75.0, dataArea, RectangleEdge.RIGHT);
        Assert.assertTrue((boolean)this.same(y4, 54.1666667, 1.0));
        double x3 = axis.java2DToValue(75.0, dataArea, RectangleEdge.TOP);
        Assert.assertTrue((boolean)this.same(x3, 91.875, 1.0));
        double x4 = axis.java2DToValue(75.0, dataArea, RectangleEdge.BOTTOM);
        Assert.assertTrue((boolean)this.same(x4, 91.875, 1.0));
    }

    public void testSerialization() {
        DateAxis a1 = new DateAxis("Test Axis");
        DateAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (DateAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = a1.equals(a2);
        Assert.assertTrue((boolean)b);
    }
}

