/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class NumberAxisTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.NumberAxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public NumberAxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = null;
        try {
            a2 = (NumberAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("NumberAxisTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testEquals() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = new NumberAxis("Test");
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeIncludesZero(false);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeIncludesZero(false);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeStickyZero(false);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeStickyZero(false);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setTickUnit(new NumberTickUnit(25.0));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setTickUnit(new NumberTickUnit(25.0));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setNumberFormatOverride(new DecimalFormat("0.00"));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setNumberFormatOverride(new DecimalFormat("0.00"));
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    private boolean same(double d1, double d2, double tolerance) {
        return Math.abs(d1 - d2) < tolerance;
    }

    public void testTranslateJava2DToValue() {
        NumberAxis axis = new NumberAxis();
        axis.setRange(50.0, 100.0);
        Rectangle2D.Double dataArea = new Rectangle2D.Double(10.0, 50.0, 400.0, 300.0);
        double y1 = axis.java2DToValue(75.0, dataArea, RectangleEdge.LEFT);
        Assert.assertTrue((boolean)this.same(y1, 95.8333333, 1.0E-6));
        double y2 = axis.java2DToValue(75.0, dataArea, RectangleEdge.RIGHT);
        Assert.assertTrue((boolean)this.same(y2, 95.8333333, 1.0E-6));
        double x1 = axis.java2DToValue(75.0, dataArea, RectangleEdge.TOP);
        Assert.assertTrue((boolean)this.same(x1, 58.125, 1.0E-6));
        double x2 = axis.java2DToValue(75.0, dataArea, RectangleEdge.BOTTOM);
        Assert.assertTrue((boolean)this.same(x2, 58.125, 1.0E-6));
        axis.setInverted(true);
        double y3 = axis.java2DToValue(75.0, dataArea, RectangleEdge.LEFT);
        Assert.assertTrue((boolean)this.same(y3, 54.1666667, 1.0E-6));
        double y4 = axis.java2DToValue(75.0, dataArea, RectangleEdge.RIGHT);
        Assert.assertTrue((boolean)this.same(y4, 54.1666667, 1.0E-6));
        double x3 = axis.java2DToValue(75.0, dataArea, RectangleEdge.TOP);
        Assert.assertTrue((boolean)this.same(x3, 91.875, 1.0E-6));
        double x4 = axis.java2DToValue(75.0, dataArea, RectangleEdge.BOTTOM);
        Assert.assertTrue((boolean)this.same(x4, 91.875, 1.0E-6));
    }

    public void testSerialization() {
        NumberAxis a1 = new NumberAxis("Test Axis");
        NumberAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (NumberAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }

    public void testAutoRange1() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart chart = ChartFactory.createBarChart("Test", "Categories", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        NumberAxis axis = (NumberAxis)chart.getCategoryPlot().getRangeAxis();
        Assert.assertTrue((boolean)this.same(axis.getLowerBound(), 0.0, 1.0E-5));
        Assert.assertTrue((boolean)this.same(axis.getUpperBound(), 210.0, 1.0E-5));
    }

    public void testAutoRange2() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart chart = ChartFactory.createBarChart("Test", "Categories", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        NumberAxis axis = (NumberAxis)chart.getCategoryPlot().getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        Assert.assertTrue((boolean)this.same(axis.getLowerBound(), 95.0, 1.0E-5));
        Assert.assertTrue((boolean)this.same(axis.getUpperBound(), 205.0, 1.0E-5));
    }

    public void testAutoRange3() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.setValue(100.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.setValue(200.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        JFreeChart chart = ChartFactory.createBarChart("Test", "Categories", "Value", dataset, PlotOrientation.VERTICAL, false, false, false);
        NumberAxis axis = (NumberAxis)chart.getCategoryPlot().getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        Assert.assertTrue((boolean)this.same(axis.getLowerBound(), 95.0, 1.0E-5));
        Assert.assertTrue((boolean)this.same(axis.getUpperBound(), 205.0, 1.0E-5));
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        dataset2.setValue(900.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset2.setValue(1000.0, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        chart.getCategoryPlot().setDataset(dataset2);
        Assert.assertTrue((boolean)this.same(axis.getLowerBound(), 895.0, 1.0E-5));
        Assert.assertTrue((boolean)this.same(axis.getUpperBound(), 1005.0, 1.0E-5));
    }
}

