/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.data.time.Year;

public class PeriodAxisTests
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.PeriodAxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public PeriodAxisTests(String name) {
        super(name);
    }

    public void testEquals() {
        PeriodAxis a1 = new PeriodAxis("Test");
        PeriodAxis a2 = new PeriodAxis("Test");
        Assert.assertTrue((boolean)a1.equals(a2));
        Assert.assertTrue((boolean)a2.equals(a1));
        a1.setFirst(new Year(2000));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setFirst(new Year(2000));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setLast(new Year(2004));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setLast(new Year(2004));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        Assert.assertTrue((boolean)a1.equals(a2));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.jfree.data.time.Quarter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        a1.setAutoRangeTimePeriodClass(clazz);
        Assert.assertFalse((boolean)a1.equals(a2));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.jfree.data.time.Quarter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        a2.setAutoRangeTimePeriodClass(clazz2);
        Assert.assertTrue((boolean)a1.equals(a2));
        PeriodAxisLabelInfo[] info = new PeriodAxisLabelInfo[1];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.jfree.data.time.Month");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        info[0] = new PeriodAxisLabelInfo(clazz3, "MMM");
        a1.setLabelInfo(info);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setLabelInfo(info);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testCloning() {
        PeriodAxis a1 = new PeriodAxis("Test");
        PeriodAxis a2 = null;
        try {
            a2 = (PeriodAxis)a1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testSerialization() {
        PeriodAxis a1 = new PeriodAxis("Test Axis");
        PeriodAxis a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (PeriodAxis)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = a1.equals(a2);
        Assert.assertTrue((boolean)b);
    }
}

