/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.SegmentedTimeline;

public class SegmentedTimelineTests
extends TestCase {
    private static final int TEST_CYCLE_START = 0;
    private static final int TEST_CYCLE_END = 1000;
    private static final int TEST_CYCLE_INC = 55;
    private static final long FIVE_YEARS = 157680000000L;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static final SimpleDateFormat DATE_FORMAT;
    private static final SimpleDateFormat DATE_TIME_FORMAT;
    private static final String[] MS_EXCEPTIONS;
    private static final String[] MS2_BASE_TIMELINE_EXCEPTIONS;
    private static final String[] US_HOLIDAYS;
    private static final String[] FIFTEEN_MIN_EXCEPTIONS;
    private SegmentedTimeline msTimeline;
    private SegmentedTimeline ms2Timeline;
    private SegmentedTimeline ms2BaseTimeline;
    private SegmentedTimeline mondayFridayTimeline;
    private SegmentedTimeline fifteenMinTimeline;
    private Calendar monday;
    private Calendar monday9am;
    static /* synthetic */ Class class$0;

    static {
        MS_EXCEPTIONS = new String[]{"0", "2", "4", "10", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "47", "58", "100", "101"};
        MS2_BASE_TIMELINE_EXCEPTIONS = new String[]{"0", "8", "16", "24", "32", "40", "48", "56", "64", "72", "80", "88", "96", "104", "112", "120", "128", "136"};
        US_HOLIDAYS = new String[]{"2000-01-17", "2000-02-21", "2000-04-21", "2000-05-29", "2000-07-04", "2000-09-04", "2000-11-23", "2000-12-25", "2001-01-01", "2001-01-15", "2001-02-19", "2001-04-13", "2001-05-28", "2001-07-04", "2001-09-03", "2001-09-11", "2001-09-12", "2001-09-13", "2001-09-14", "2001-11-22", "2001-12-25", "2002-01-01", "2002-01-21", "2002-02-18", "2002-03-29", "2002-05-27", "2002-07-04", "2002-09-02", "2002-11-28", "2002-12-25"};
        FIFTEEN_MIN_EXCEPTIONS = new String[]{"2000-01-10 09:00:00", "2000-01-10 09:15:00", "2000-01-10 09:30:00", "2000-01-10 09:45:00", "2000-01-10 10:00:00", "2000-01-10 10:15:00", "2000-02-15 09:00:00", "2000-02-15 09:15:00", "2000-02-15 09:30:00", "2000-02-15 09:45:00", "2000-02-15 10:00:00", "2000-02-15 10:15:00", "2000-02-16 11:00:00", "2000-02-16 11:15:00", "2000-02-16 11:30:00", "2000-02-16 11:45:00", "2000-02-16 12:00:00", "2000-02-16 12:15:00", "2000-02-16 12:30:00", "2000-02-16 12:45:00", "2000-02-16 01:00:00", "2000-02-16 01:15:00", "2000-02-16 01:30:00", "2000-02-16 01:45:00", "2000-05-17 11:45:00", "2000-05-17 12:00:00", "2000-05-17 12:15:00", "2000-05-17 12:30:00", "2000-05-17 12:45:00", "2000-05-17 01:00:00", "2000-05-17 01:15:00", "2000-05-17 01:30:00", "2000-05-17 01:45:00", "2000-05-17 02:00:00", "2000-05-17 02:15:00", "2000-05-17 02:30:00", "2000-05-17 02:45:00", "2000-05-17 03:00:00", "2000-05-17 03:15:00", "2000-05-17 03:30:00", "2000-05-17 03:45:00", "2000-05-17 04:00:00"};
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DATE_FORMAT.setTimeZone(SegmentedTimeline.NO_DST_TIME_ZONE);
        DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DATE_TIME_FORMAT.setTimeZone(SegmentedTimeline.NO_DST_TIME_ZONE);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.SegmentedTimelineTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public SegmentedTimelineTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.msTimeline = new SegmentedTimeline(1L, 5, 2);
        this.msTimeline.setStartTime(0L);
        this.ms2BaseTimeline = new SegmentedTimeline(4L, 1, 1);
        this.ms2BaseTimeline.setStartTime(0L);
        this.ms2Timeline = new SegmentedTimeline(1L, 2, 2);
        this.ms2Timeline.setStartTime(1L);
        this.ms2Timeline.setBaseTimeline(this.ms2BaseTimeline);
        this.mondayFridayTimeline = SegmentedTimeline.newMondayThroughFridayTimeline();
        this.fifteenMinTimeline = SegmentedTimeline.newFifteenMinuteTimeline();
        GregorianCalendar cal = new GregorianCalendar(SegmentedTimeline.NO_DST_TIME_ZONE);
        cal.set(2001, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        while (cal.get(7) != 2) {
            ((Calendar)cal).add(5, 1);
        }
        this.monday = (Calendar)((Calendar)cal).clone();
        ((Calendar)cal).add(10, 9);
        this.monday9am = (Calendar)((Calendar)cal).clone();
    }

    protected void tearDown() throws Exception {
    }

    public void testMsSegmentedTimeline() {
        Assert.assertEquals((long)1L, (long)this.msTimeline.getSegmentSize());
        Assert.assertEquals((long)0L, (long)this.msTimeline.getStartTime());
        Assert.assertEquals((int)5, (int)this.msTimeline.getSegmentsIncluded());
        Assert.assertEquals((int)2, (int)this.msTimeline.getSegmentsExcluded());
    }

    public void testMs2SegmentedTimeline() {
        Assert.assertEquals((long)1L, (long)this.ms2Timeline.getSegmentSize());
        Assert.assertEquals((long)1L, (long)this.ms2Timeline.getStartTime());
        Assert.assertEquals((int)2, (int)this.ms2Timeline.getSegmentsIncluded());
        Assert.assertEquals((int)2, (int)this.ms2Timeline.getSegmentsExcluded());
        Assert.assertEquals((Object)this.ms2BaseTimeline, (Object)this.ms2Timeline.getBaseTimeline());
    }

    public void testMondayThroughFridaySegmentedTimeline() {
        Assert.assertEquals((long)86400000L, (long)this.mondayFridayTimeline.getSegmentSize());
        Assert.assertEquals((long)SegmentedTimeline.FIRST_MONDAY_AFTER_1900, (long)this.mondayFridayTimeline.getStartTime());
        Assert.assertEquals((int)5, (int)this.mondayFridayTimeline.getSegmentsIncluded());
        Assert.assertEquals((int)2, (int)this.mondayFridayTimeline.getSegmentsExcluded());
    }

    public void testFifteenMinSegmentedTimeline() {
        Assert.assertEquals((long)900000L, (long)this.fifteenMinTimeline.getSegmentSize());
        Assert.assertEquals((long)(SegmentedTimeline.FIRST_MONDAY_AFTER_1900 + 36L * this.fifteenMinTimeline.getSegmentSize()), (long)this.fifteenMinTimeline.getStartTime());
        Assert.assertEquals((int)28, (int)this.fifteenMinTimeline.getSegmentsIncluded());
        Assert.assertEquals((int)68, (int)this.fifteenMinTimeline.getSegmentsExcluded());
    }

    public void testMsSegment() {
        this.verifyOneSegment(this.msTimeline);
    }

    public void testMs2Segment() {
        this.verifyOneSegment(this.ms2Timeline);
    }

    public void testMondayThroughFridaySegment() {
        this.verifyOneSegment(this.mondayFridayTimeline);
    }

    public void testFifteenMinSegment() {
        this.verifyOneSegment(this.fifteenMinTimeline);
    }

    public void verifyOneSegment(SegmentedTimeline timeline) {
        long testCycle = 0L;
        while (testCycle < 1000L) {
            SegmentedTimeline.Segment seg;
            SegmentedTimeline.Segment segment1 = timeline.getSegment(this.monday.getTime().getTime() + testCycle);
            SegmentedTimeline.Segment segment2 = timeline.getSegment(segment1.getSegmentEnd() + 1L);
            Assert.assertEquals((long)(segment1.getSegmentNumber() + 1L), (long)segment2.getSegmentNumber());
            Assert.assertEquals((long)(segment1.getSegmentEnd() + 1L), (long)segment2.getSegmentStart());
            Assert.assertEquals((long)(segment1.getSegmentStart() + timeline.getSegmentSize() - 1L), (long)segment1.getSegmentEnd());
            Assert.assertEquals((long)(segment1.getSegmentStart() + timeline.getSegmentSize()), (long)segment2.getSegmentStart());
            Assert.assertEquals((long)(segment1.getSegmentEnd() + timeline.getSegmentSize()), (long)segment2.getSegmentEnd());
            long delta = timeline.getSegmentSize() > 1000000L ? timeline.getSegmentSize() / 10000L : (timeline.getSegmentSize() > 100000L ? timeline.getSegmentSize() / 1000L : (timeline.getSegmentSize() > 10000L ? timeline.getSegmentSize() / 100L : (timeline.getSegmentSize() > 1000L ? timeline.getSegmentSize() / 10L : (timeline.getSegmentSize() > 100L ? timeline.getSegmentSize() / 5L : 1L))));
            long start = segment1.getSegmentStart() + delta;
            long end = segment1.getSegmentStart() + timeline.getSegmentSize() - 1L;
            SegmentedTimeline.Segment lastSeg = timeline.getSegment(segment1.getSegmentStart());
            long i = start;
            while (i < end) {
                seg = timeline.getSegment(i);
                Assert.assertEquals((long)lastSeg.getSegmentNumber(), (long)seg.getSegmentNumber());
                Assert.assertEquals((long)lastSeg.getSegmentStart(), (long)seg.getSegmentStart());
                Assert.assertEquals((long)lastSeg.getSegmentEnd(), (long)seg.getSegmentEnd());
                Assert.assertTrue((lastSeg.getMillisecond() < seg.getMillisecond() ? 1 : 0) != 0);
                lastSeg = seg;
                i += delta;
            }
            seg = timeline.getSegment(end + 1L);
            Assert.assertEquals((long)segment2.getSegmentNumber(), (long)seg.getSegmentNumber());
            Assert.assertEquals((long)segment2.getSegmentStart(), (long)seg.getSegmentStart());
            Assert.assertEquals((long)segment2.getSegmentEnd(), (long)seg.getSegmentEnd());
            testCycle += 55L;
        }
    }

    public void testMsInc() {
        this.verifyInc(this.msTimeline);
    }

    public void testMs2Inc() {
        this.verifyInc(this.ms2Timeline);
    }

    public void testMondayThroughFridayInc() {
        this.verifyInc(this.mondayFridayTimeline);
    }

    public void testFifteenMinInc() {
        this.verifyInc(this.fifteenMinTimeline);
    }

    public void verifyInc(SegmentedTimeline timeline) {
        long testCycle = 0L;
        while (testCycle < 1000L) {
            long m = timeline.getSegmentSize();
            SegmentedTimeline.Segment segment = timeline.getSegment(testCycle);
            SegmentedTimeline.Segment seg1 = segment.copy();
            int i = 0;
            while (i < 1000) {
                SegmentedTimeline.Segment seg2 = seg1.copy();
                seg2.inc();
                if (seg1.getSegmentEnd() + 1L != seg2.getSegmentStart()) {
                    Assert.assertTrue((!timeline.containsDomainRange(seg1.getSegmentEnd() + 1L, seg2.getSegmentStart() - 1L) ? 1 : 0) != 0);
                    Assert.assertEquals((long)0L, (long)((seg2.getSegmentStart() - seg1.getSegmentStart()) % m));
                    Assert.assertEquals((long)0L, (long)((seg2.getSegmentEnd() - seg1.getSegmentEnd()) % m));
                    Assert.assertEquals((long)0L, (long)((seg2.getMillisecond() - seg1.getMillisecond()) % m));
                } else {
                    Assert.assertEquals((long)(seg1.getSegmentStart() + m), (long)seg2.getSegmentStart());
                    Assert.assertEquals((long)(seg1.getSegmentEnd() + m), (long)seg2.getSegmentEnd());
                    Assert.assertEquals((long)(seg1.getMillisecond() + m), (long)seg2.getMillisecond());
                }
                SegmentedTimeline.Segment seg3 = seg1.copy();
                SegmentedTimeline.Segment seg4 = seg1.copy();
                int j = 0;
                while (j < i) {
                    seg3.inc();
                    ++j;
                }
                seg4.inc(i);
                Assert.assertEquals((long)seg3.getSegmentStart(), (long)seg4.getSegmentStart());
                Assert.assertEquals((long)seg3.getSegmentEnd(), (long)seg4.getSegmentEnd());
                Assert.assertEquals((long)seg3.getMillisecond(), (long)seg4.getMillisecond());
                seg1.inc();
                ++i;
            }
            testCycle += 55L;
        }
    }

    public void testMsIncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.msTimeline, 0L);
    }

    public void testMs2IncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.ms2Timeline, 1L);
    }

    public void testMondayThroughFridayIncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.mondayFridayTimeline, this.monday.getTime().getTime());
    }

    public void testFifteenMinIncludedAndExcludedSegments() {
        this.verifyIncludedAndExcludedSegments(this.fifteenMinTimeline, this.monday9am.getTime().getTime());
    }

    public void verifyIncludedAndExcludedSegments(SegmentedTimeline timeline, long n) {
        timeline.setExceptionSegments(new ArrayList());
        SegmentedTimeline.Segment segment = timeline.getSegment(n);
        int i = 0;
        while (i < 1000) {
            int d = i % timeline.getGroupSegmentCount();
            if (d < timeline.getSegmentsIncluded()) {
                Assert.assertTrue((boolean)segment.inIncludeSegments());
                Assert.assertTrue((!segment.inExcludeSegments() ? 1 : 0) != 0);
                Assert.assertTrue((!segment.inExceptionSegments() ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((!segment.inIncludeSegments() ? 1 : 0) != 0);
                Assert.assertTrue((boolean)segment.inExcludeSegments());
                Assert.assertTrue((!segment.inExceptionSegments() ? 1 : 0) != 0);
            }
            segment.inc();
            ++i;
        }
    }

    public void testMsExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.msTimeline, MS_EXCEPTIONS, NUMBER_FORMAT);
    }

    public void testMs2BaseTimelineExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.ms2BaseTimeline, MS2_BASE_TIMELINE_EXCEPTIONS, NUMBER_FORMAT);
    }

    public void testMondayThoughFridayExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.mondayFridayTimeline, US_HOLIDAYS, DATE_FORMAT);
    }

    public void testFifteenMinExceptionSegments() throws ParseException {
        this.verifyExceptionSegments(this.fifteenMinTimeline, FIFTEEN_MIN_EXCEPTIONS, DATE_TIME_FORMAT);
    }

    public void verifyExceptionSegments(SegmentedTimeline timeline, String[] exceptionString, Format fmt) throws ParseException {
        long[] exception = this.verifyFillInExceptions(timeline, exceptionString, fmt);
        int m = exception.length;
        Assert.assertEquals((int)exception.length, (int)timeline.getExceptionSegments().size());
        SegmentedTimeline.Segment lastSegment = timeline.getSegment(exception[m - 1]);
        int i = 0;
        while (i < m) {
            SegmentedTimeline.Segment segment = timeline.getSegment(exception[i]);
            Assert.assertTrue((boolean)segment.inExceptionSegments());
            Assert.assertEquals((long)(m - i), (long)timeline.getExceptionSegmentCount(segment.getSegmentStart(), lastSegment.getSegmentEnd()));
            Assert.assertEquals((long)Math.max(0, m - i - 2), (long)timeline.getExceptionSegmentCount(exception[i] + 1L, exception[m - 1] - 1L));
            ++i;
        }
    }

    public void testMsTranslations() throws ParseException {
        this.verifyFillInExceptions(this.msTimeline, MS_EXCEPTIONS, NUMBER_FORMAT);
        this.verifyTranslations(this.msTimeline, 0L);
    }

    public void testMs2BaseTimelineTranslations() throws ParseException {
        this.verifyFillInExceptions(this.ms2BaseTimeline, MS2_BASE_TIMELINE_EXCEPTIONS, NUMBER_FORMAT);
        this.verifyTranslations(this.ms2BaseTimeline, 0L);
    }

    public void testMs2Translations() throws ParseException {
        this.fillInBaseTimelineExceptions(this.ms2Timeline, MS2_BASE_TIMELINE_EXCEPTIONS, NUMBER_FORMAT);
        this.fillInBaseTimelineExclusionsAsExceptions(this.ms2Timeline, 0L, 5000L);
        this.verifyTranslations(this.ms2Timeline, 1L);
    }

    public void testMondayThroughFridayTranslations() throws ParseException {
        this.verifyFillInExceptions(this.mondayFridayTimeline, US_HOLIDAYS, DATE_FORMAT);
        this.verifyTranslations(this.mondayFridayTimeline, this.monday.getTime().getTime());
    }

    public void testFifteenMinTranslations() throws ParseException {
        this.verifyFillInExceptions(this.fifteenMinTimeline, FIFTEEN_MIN_EXCEPTIONS, DATE_TIME_FORMAT);
        this.fillInBaseTimelineExceptions(this.fifteenMinTimeline, US_HOLIDAYS, DATE_FORMAT);
        this.fillInBaseTimelineExclusionsAsExceptions(this.fifteenMinTimeline, this.monday9am.getTime().getTime(), this.monday9am.getTime().getTime() + 157680000000L);
        this.verifyTranslations(this.fifteenMinTimeline, this.monday9am.getTime().getTime());
    }

    public void verifyTranslations(SegmentedTimeline timeline, long startTest) {
        long testCycle = 0L;
        while (testCycle < 1000L) {
            long millisecond = startTest + testCycle * timeline.getSegmentSize();
            SegmentedTimeline.Segment segment = timeline.getSegment(millisecond);
            int i = 0;
            while (i < 1000) {
                long translatedValue = timeline.toTimelineValue(segment.getMillisecond());
                long newValue = timeline.toMillisecond(translatedValue);
                if (segment.inExcludeSegments() || segment.inExceptionSegments()) {
                    SegmentedTimeline.Segment tempSegment = segment.copy();
                    tempSegment.moveIndexToStart();
                    do {
                        tempSegment.inc();
                    } while (!tempSegment.inIncludeSegments());
                    Assert.assertEquals((long)tempSegment.getMillisecond(), (long)newValue);
                } else {
                    Assert.assertEquals((long)segment.getMillisecond(), (long)newValue);
                }
                segment.inc();
                ++i;
            }
            testCycle += 55L;
        }
    }

    public void testSerialization() {
        this.verifySerialization(this.msTimeline);
        this.verifySerialization(this.ms2Timeline);
        this.verifySerialization(this.ms2BaseTimeline);
        this.verifySerialization(SegmentedTimeline.newMondayThroughFridayTimeline());
        this.verifySerialization(SegmentedTimeline.newFifteenMinuteTimeline());
    }

    private void verifySerialization(SegmentedTimeline a1) {
        SegmentedTimeline a2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(a1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            a2 = (SegmentedTimeline)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)a1, a2);
    }

    private long[] verifyFillInExceptions(SegmentedTimeline timeline, String[] exceptionString, Format fmt) throws ParseException {
        timeline.setExceptionSegments(new ArrayList());
        Assert.assertEquals((int)0, (int)timeline.getExceptionSegments().size());
        ArrayList<Long> exceptionList = new ArrayList<Long>();
        int i = 0;
        while (i < exceptionString.length) {
            long e = fmt instanceof NumberFormat ? ((NumberFormat)fmt).parse(exceptionString[i]).longValue() : timeline.getTime(((SimpleDateFormat)fmt).parse(exceptionString[i]));
            SegmentedTimeline.Segment segment = timeline.getSegment(e);
            if (segment.inIncludeSegments()) {
                timeline.addException(e);
                exceptionList.add(new Long(e));
                Assert.assertEquals((int)exceptionList.size(), (int)timeline.getExceptionSegments().size());
                Assert.assertTrue((boolean)segment.inExceptionSegments());
            }
            ++i;
        }
        long[] exception = new long[exceptionList.size()];
        int i2 = 0;
        Iterator iter = exceptionList.iterator();
        while (iter.hasNext()) {
            Long l = (Long)iter.next();
            exception[i2++] = l;
        }
        return exception;
    }

    private void fillInBaseTimelineExceptions(SegmentedTimeline timeline, String[] exceptionString, Format fmt) throws ParseException {
        SegmentedTimeline baseTimeline = timeline.getBaseTimeline();
        int i = 0;
        while (i < exceptionString.length) {
            long e = fmt instanceof NumberFormat ? ((NumberFormat)fmt).parse(exceptionString[i]).longValue() : timeline.getTime(((SimpleDateFormat)fmt).parse(exceptionString[i]));
            timeline.addBaseTimelineException(e);
            SegmentedTimeline.Segment segment1 = baseTimeline.getSegment(e);
            SegmentedTimeline.Segment segment2 = timeline.getSegment(segment1.getSegmentStart());
            while (segment2.getSegmentStart() <= segment1.getSegmentEnd()) {
                if (!segment2.inExcludeSegments()) {
                    Assert.assertTrue((boolean)segment2.inExceptionSegments());
                }
                segment2.inc();
            }
            ++i;
        }
    }

    private void fillInBaseTimelineExclusionsAsExceptions(SegmentedTimeline timeline, long from, long to) {
        timeline.addBaseTimelineExclusions(from, to);
        SegmentedTimeline.Segment segment1 = timeline.getBaseTimeline().getSegment(from);
        while (segment1.getSegmentStart() <= to) {
            if (segment1.inExcludeSegments()) {
                SegmentedTimeline.Segment segment2 = timeline.getSegment(segment1.getSegmentStart());
                while (segment2.getSegmentStart() <= segment1.getSegmentEnd()) {
                    if (!segment2.inExcludeSegments()) {
                        Assert.assertTrue((boolean)segment2.inExceptionSegments());
                    }
                    segment2.inc();
                }
            }
            segment1.inc();
        }
    }

    public void testCloning() {
        SegmentedTimeline l1 = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline l2 = null;
        try {
            l2 = (SegmentedTimeline)l1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("SegmentedTimelineTests2.testCloning: failed to clone.");
        }
        Assert.assertTrue((l1 != l2 ? 1 : 0) != 0);
        Assert.assertTrue((l1.getClass() == l2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)l1.equals(l2));
    }

    public void testEquals() {
        SegmentedTimeline l1 = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline l2 = new SegmentedTimeline(1000L, 5, 2);
        Assert.assertTrue((boolean)l1.equals(l2));
        l1 = new SegmentedTimeline(1000L, 5, 2);
        l2 = new SegmentedTimeline(1001L, 5, 2);
        Assert.assertFalse((boolean)l1.equals(l2));
        l1 = new SegmentedTimeline(1000L, 5, 2);
        l2 = new SegmentedTimeline(1000L, 4, 2);
        Assert.assertFalse((boolean)l1.equals(l2));
        l1 = new SegmentedTimeline(1000L, 5, 2);
        l2 = new SegmentedTimeline(1000L, 5, 1);
        Assert.assertFalse((boolean)l1.equals(l2));
        l1 = new SegmentedTimeline(1000L, 5, 2);
        l2 = new SegmentedTimeline(1000L, 5, 2);
        l1.setStartTime(1234L);
        Assert.assertFalse((boolean)l1.equals(l2));
        l2.setStartTime(1234L);
        Assert.assertTrue((boolean)l1.equals(l2));
    }

    public void testSerialization2() {
        SegmentedTimeline l1 = new SegmentedTimeline(1000L, 5, 2);
        SegmentedTimeline l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (SegmentedTimeline)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        boolean b = l1.equals(l2);
        Assert.assertTrue((boolean)b);
    }

    public void testBasicSegmentedTimeline() {
        SegmentedTimeline stl = new SegmentedTimeline(10L, 2, 3);
        stl.setStartTime(946684800000L);
        Assert.assertFalse((boolean)stl.containsDomainValue(946684799999L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800000L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800019L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800020L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800049L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800050L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800069L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800070L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800099L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800100L));
        Assert.assertEquals((long)0L, (long)stl.toTimelineValue(946684800000L));
        Assert.assertEquals((long)19L, (long)stl.toTimelineValue(946684800019L));
        Assert.assertEquals((long)20L, (long)stl.toTimelineValue(946684800020L));
        Assert.assertEquals((long)20L, (long)stl.toTimelineValue(946684800049L));
        Assert.assertEquals((long)20L, (long)stl.toTimelineValue(946684800050L));
        Assert.assertEquals((long)39L, (long)stl.toTimelineValue(946684800069L));
        Assert.assertEquals((long)40L, (long)stl.toTimelineValue(946684800070L));
        Assert.assertEquals((long)40L, (long)stl.toTimelineValue(946684800099L));
        Assert.assertEquals((long)40L, (long)stl.toTimelineValue(946684800100L));
        Assert.assertEquals((long)946684800000L, (long)stl.toMillisecond(0L));
        Assert.assertEquals((long)946684800019L, (long)stl.toMillisecond(19L));
        Assert.assertEquals((long)946684800050L, (long)stl.toMillisecond(20L));
        Assert.assertEquals((long)946684800069L, (long)stl.toMillisecond(39L));
        Assert.assertEquals((long)946684800100L, (long)stl.toMillisecond(40L));
    }

    public void testSegmentedTimelineWithException1() {
        SegmentedTimeline stl = new SegmentedTimeline(10L, 2, 3);
        stl.setStartTime(946684800000L);
        stl.addException(946684800050L);
        Assert.assertFalse((boolean)stl.containsDomainValue(946684799999L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800000L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800019L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800020L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800049L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800050L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800059L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800060L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800069L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800070L));
        Assert.assertFalse((boolean)stl.containsDomainValue(946684800099L));
        Assert.assertTrue((boolean)stl.containsDomainValue(946684800100L));
        Assert.assertEquals((long)0L, (long)stl.toTimelineValue(946684800000L));
        Assert.assertEquals((long)19L, (long)stl.toTimelineValue(946684800019L));
        Assert.assertEquals((long)20L, (long)stl.toTimelineValue(946684800020L));
        Assert.assertEquals((long)20L, (long)stl.toTimelineValue(946684800049L));
        Assert.assertEquals((long)20L, (long)stl.toTimelineValue(946684800050L));
        Assert.assertEquals((long)29L, (long)stl.toTimelineValue(946684800069L));
        Assert.assertEquals((long)30L, (long)stl.toTimelineValue(946684800070L));
        Assert.assertEquals((long)30L, (long)stl.toTimelineValue(946684800099L));
        Assert.assertEquals((long)30L, (long)stl.toTimelineValue(946684800100L));
        Assert.assertEquals((long)946684800000L, (long)stl.toMillisecond(0L));
        Assert.assertEquals((long)946684800019L, (long)stl.toMillisecond(19L));
        Assert.assertEquals((long)946684800060L, (long)stl.toMillisecond(20L));
        Assert.assertEquals((long)946684800069L, (long)stl.toMillisecond(29L));
        Assert.assertEquals((long)946684800100L, (long)stl.toMillisecond(30L));
    }

    public static void main(String[] args) throws Exception {
        SegmentedTimelineTests test = new SegmentedTimelineTests("Test");
        test.setUp();
        test.testMondayThoughFridayExceptionSegments();
        test.tearDown();
    }
}

