/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.util.NumberUtils;

public class ValueAxisTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.axis.junit.ValueAxisTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ValueAxisTests(String name) {
        super(name);
    }

    public void testCloning() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = null;
        try {
            a2 = (NumberAxis)((ValueAxis)a1).clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("ValueAxisTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((a1 != a2 ? 1 : 0) != 0);
        Assert.assertTrue((a1.getClass() == a2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((ValueAxis)a1).equals(a2));
    }

    public void testEquals() {
        NumberAxis a1 = new NumberAxis("Test");
        NumberAxis a2 = new NumberAxis("Test");
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAxisLineVisible(false);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAxisLineVisible(false);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setPositiveArrowVisible(true);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setPositiveArrowVisible(true);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setNegativeArrowVisible(true);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setNegativeArrowVisible(true);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAxisLinePaint(Color.blue);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAxisLinePaint(Color.blue);
        Assert.assertTrue((boolean)a1.equals(a2));
        BasicStroke stroke = new BasicStroke(2.0f);
        a1.setAxisLineStroke(stroke);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAxisLineStroke(stroke);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setInverted(true);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setInverted(true);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setRange(new Range(50.0, 75.0));
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setRange(new Range(50.0, 75.0));
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRange(true);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRange(true);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAutoRangeMinimumSize(3.33);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAutoRangeMinimumSize(3.33);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setUpperMargin(0.09);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setUpperMargin(0.09);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setLowerMargin(0.09);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setLowerMargin(0.09);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setFixedAutoRange(50.0);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setFixedAutoRange(50.0);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setAutoTickUnitSelection(false);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setAutoTickUnitSelection(false);
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        Assert.assertTrue((boolean)a1.equals(a2));
        a1.setVerticalTickLabels(true);
        Assert.assertFalse((boolean)a1.equals(a2));
        a2.setVerticalTickLabels(true);
        Assert.assertTrue((boolean)a1.equals(a2));
    }

    public void testAxisMargins() {
        XYSeries series = new XYSeries("S1");
        series.add(100.0, 1.1);
        series.add(200.0, 2.2);
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        dataset.setIntervalWidth(0.0);
        JFreeChart chart = ChartFactory.createScatterPlot("Title", "X", "Y", dataset, PlotOrientation.VERTICAL, false, false, false);
        ValueAxis domainAxis = chart.getXYPlot().getDomainAxis();
        Range r = domainAxis.getRange();
        Assert.assertTrue((boolean)NumberUtils.equal(110.0, r.getLength()));
        domainAxis.setLowerMargin(0.1);
        domainAxis.setUpperMargin(0.1);
        r = domainAxis.getRange();
        Assert.assertTrue((boolean)NumberUtils.equal(120.0, r.getLength()));
    }
}

