/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer3D;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChart3DDemo1
extends ApplicationFrame {
    public BarChart3DDemo1(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{10.0, 4.0, 15.0, 14.0}, {-5.0, -7.0, 14.0, -3.0}, {6.0, 17.0, -12.0, 7.0}, {7.0, 15.0, 11.0, 0.0}, {-8.0, -6.0, 10.0, -9.0}, {9.0, 8.0, 0.0, 6.0}, {-10.0, 9.0, 7.0, 7.0}, {11.0, 13.0, 9.0, 9.0}, {-3.0, 7.0, 11.0, -10.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])data);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart3D("3D Bar Chart Demo", "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis axis = plot.getDomainAxis();
        axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(0.39269908169872414));
        BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        return chart;
    }

    public static void main(String[] args) {
        BarChart3DDemo1 demo = new BarChart3DDemo1("3D Bar Chart Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

