/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class BarChart3DDemo2
extends ApplicationFrame {
    public BarChart3DDemo2(String title) {
        super(title);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(23.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"London"));
        dataset.addValue(14.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"New York"));
        dataset.addValue(14.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Istanbul"));
        dataset.addValue(14.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Cairo"));
        dataset.addValue(13.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"London"));
        dataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"New York"));
        dataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Istanbul"));
        dataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Cairo"));
        dataset.addValue(7.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"London"));
        dataset.addValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"New York"));
        dataset.addValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Istanbul"));
        dataset.addValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Cairo"));
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart3D("3D Bar Chart Demo 2", "Category", "Value", dataset, PlotOrientation.HORIZONTAL, true, true, false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setForegroundAlpha(1.0f);
        CategoryAxis axis = plot.getDomainAxis();
        CategoryLabelPositions p = axis.getCategoryLabelPositions();
        CategoryLabelPosition left = new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, 0.0, CategoryLabelWidthType.RANGE, 0.3f);
        axis.setCategoryLabelPositions(CategoryLabelPositions.replaceLeftPosition(p, left));
        return chart;
    }

    public static void main(String[] args) {
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        BarChart3DDemo2 demo = new BarChart3DDemo2("3D Bar Chart Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

