/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChart3DDemo3
extends ApplicationFrame {
    public BarChart3DDemo3(String title) {
        super(title);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(25.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        dataset.addValue(34.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        dataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
        dataset.addValue(29.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
        dataset.addValue(41.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 1"));
        dataset.addValue(33.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 2"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart3D("3D Bar Chart Demo", "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis axis = plot.getDomainAxis();
        axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(0.39269908169872414));
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setItemLabelsVisible(true);
        BarRenderer r = (BarRenderer)renderer;
        r.setMaxBarWidth(0.05);
        return chart;
    }

    public static void main(String[] args) {
        BarChart3DDemo3 demo = new BarChart3DDemo3("3D Bar Chart Demo 3");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

