/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public class BoxAndWhiskerDemo
extends ApplicationFrame {
    private static final LogContext LOGGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.chart.demo.BoxAndWhiskerDemo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = Log.createContext(clazz);
    }

    public BoxAndWhiskerDemo(String title) {
        super(title);
        BoxAndWhiskerCategoryDataset dataset = this.createSampleDataset();
        CategoryAxis xAxis = new CategoryAxis("Type");
        NumberAxis yAxis = new NumberAxis("Value");
        yAxis.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
        renderer.setFillBox(false);
        renderer.setToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
        CategoryPlot plot = new CategoryPlot(dataset, xAxis, yAxis, renderer);
        JFreeChart chart = new JFreeChart("Box-and-Whisker Demo", new Font("SansSerif", 1, 14), plot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(450, 270));
        this.setContentPane(chartPanel);
    }

    private BoxAndWhiskerCategoryDataset createSampleDataset() {
        int seriesCount = 3;
        int categoryCount = 4;
        int entityCount = 22;
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 4) {
                ArrayList<Double> list = new ArrayList<Double>();
                int k = 0;
                while (k < 22) {
                    double value1 = 10.0 + Math.random() * 3.0;
                    list.add(new Double(value1));
                    double value2 = 11.25 + Math.random();
                    list.add(new Double(value2));
                    ++k;
                }
                LOGGER.debug("Adding series " + i);
                LOGGER.debug(((Object)list).toString());
                dataset.add(list, (Comparable)((Object)("Series " + i)), (Comparable)((Object)(" Type " + j)));
                ++j;
            }
            ++i;
        }
        return dataset;
    }

    public static void main(String[] args) {
        BoxAndWhiskerDemo demo = new BoxAndWhiskerDemo("Box-and-Whisker Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

