/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.MatrixSeriesCollection;
import org.jfree.data.NormalizedMatrixSeries;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BubblyBubblesDemo2
extends ApplicationFrame {
    private static final int SIZE = 10;
    private static final String TITLE = "Population count at grid locations";
    NormalizedMatrixSeries series = this.createInitialSeries();

    public BubblyBubblesDemo2(String title) {
        super(title);
        MatrixSeriesCollection dataset = new MatrixSeriesCollection(this.series);
        JFreeChart chart = ChartFactory.createBubbleChart(TITLE, "X", "Y", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.yellow));
        XYPlot plot = chart.getXYPlot();
        plot.setForegroundAlpha(0.5f);
        NumberAxis domainAxis = (NumberAxis)plot.getDomainAxis();
        domainAxis.setLowerBound(-0.5);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setLowerBound(-0.5);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setVerticalZoom(true);
        chartPanel.setHorizontalZoom(true);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] args) {
        BubblyBubblesDemo2 demo = new BubblyBubblesDemo2(TITLE);
        demo.pack();
        demo.setSize(800, 600);
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
        UpdaterThread updater = demo.new UpdaterThread();
        updater.setDaemon(true);
        updater.start();
    }

    private NormalizedMatrixSeries createInitialSeries() {
        NormalizedMatrixSeries newSeries = new NormalizedMatrixSeries("Sample Grid 1", 10, 10);
        int count = 0;
        while (count < 30) {
            int i = (int)(Math.random() * 10.0);
            int j = (int)(Math.random() * 10.0);
            double mij = Math.random() * 1.0;
            newSeries.update(i, j, mij);
            ++count;
        }
        newSeries.setScaleFactor(newSeries.getItemCount());
        return newSeries;
    }

    private class UpdaterThread
    extends Thread {
        UpdaterThread() {
        }

        public void run() {
            this.setPriority(1);
            while (true) {
                int i = (int)(Math.random() * 10.0);
                int j = (int)(Math.random() * 10.0);
                double change = Math.random() * 3.0 - 1.0;
                BubblyBubblesDemo2.this.series.update(i, j, BubblyBubblesDemo2.this.series.get(i, j) + change);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

