/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.HighLowDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CandlestickDemo
extends ApplicationFrame {
    public CandlestickDemo(String title) {
        super(title);
        HighLowDataset dataset = DemoDatasetFactory.createHighLowDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.getXYPlot().setOrientation(PlotOrientation.VERTICAL);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(HighLowDataset dataset) {
        JFreeChart chart = ChartFactory.createCandlestickChart("Candlestick Demo", "Time", "Value", dataset, true);
        return chart;
    }

    public static void main(String[] args) {
        CandlestickDemo demo = new CandlestickDemo("Candlestick Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

