/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Timer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;

public class ChartTiming4
implements ActionListener {
    private boolean finished;
    private float[][] data = new float[2][1440];

    public void run() {
        this.finished = false;
        this.populateData();
        FastScatterPlot plot = new FastScatterPlot(this.data, new NumberAxis("X"), new NumberAxis("Y"));
        JFreeChart chart = new JFreeChart("Fast Scatter Plot Timing", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        BufferedImage image = new BufferedImage(400, 300, 1);
        Graphics2D g2 = image.createGraphics();
        Rectangle2D.Double chartArea = new Rectangle2D.Double(0.0, 0.0, 400.0, 300.0);
        Timer timer = new Timer(10000, this);
        timer.setRepeats(false);
        int count = 0;
        timer.start();
        while (!this.finished) {
            chart.draw(g2, chartArea, null, null);
            System.out.println("Charts drawn..." + count);
            if (this.finished) continue;
            ++count;
        }
        System.out.println("DONE");
    }

    public void actionPerformed(ActionEvent event) {
        this.finished = true;
    }

    private void populateData() {
        int i = 0;
        while (i < this.data[0].length) {
            float x;
            this.data[0][i] = x = (float)i;
            this.data[1][i] = 100.0f + 2.0f * x + (float)Math.random() * 1440.0f;
            ++i;
        }
    }

    public static void main(String[] args) {
        ChartTiming4 app = new ChartTiming4();
        app.run();
    }
}

