/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.MovingAverage;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CombinedXYPlotDemo3
extends ApplicationFrame {
    public CombinedXYPlotDemo3(String title) {
        super(title);
        JFreeChart chart = this.createCombinedChart();
        ChartPanel panel = new ChartPanel(chart, true, true, true, false, true);
        panel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(panel);
    }

    private JFreeChart createCombinedChart() {
        TimeSeriesCollection dataset0 = new TimeSeriesCollection();
        TimeSeries eur = DemoDatasetFactory.createEURTimeSeries();
        dataset0.addSeries(eur);
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        TimeSeries mav = MovingAverage.createMovingAverage(eur, "EUR/GBP (30 Day MA)", 30, 30);
        dataset1.addSeries(eur);
        dataset1.addSeries(mav);
        TimeSeriesCollection dataset2 = new TimeSeriesCollection();
        dataset2.addSeries(eur);
        JFreeChart chart = null;
        NumberAxis valueAxis = new NumberAxis("Value");
        valueAxis.setAutoRangeIncludesZero(false);
        CombinedRangeXYPlot parent = new CombinedRangeXYPlot(valueAxis);
        XYPlot subplot1 = new XYPlot(dataset0, new DateAxis("Date 1"), null, new StandardXYItemRenderer());
        parent.add(subplot1, 1);
        XYPlot subplot2 = new XYPlot(dataset1, new DateAxis("Date 2"), null, new StandardXYItemRenderer());
        parent.add(subplot2, 1);
        XYPlot subplot3 = new XYPlot(dataset2, new DateAxis("Date 3"), null, new XYBarRenderer(0.2));
        parent.add(subplot3, 1);
        chart = new JFreeChart("Demo Chart", JFreeChart.DEFAULT_TITLE_FONT, parent, true);
        TextTitle subtitle = new TextTitle("This is a subtitle", new Font("SansSerif", 1, 12));
        chart.addSubtitle(subtitle);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return chart;
    }

    public static void main(String[] args) {
        CombinedXYPlotDemo3 demo = new CombinedXYPlotDemo3("Combined XY Plot Demo 3");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

