/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.data.DefaultValueDataset;
import org.jfree.ui.Spinner;

public class CompassDemo
extends JPanel {
    public static final boolean DEBUG = true;
    public static final String[] NEEDLE_TYPES = new String[]{"Arrow", "Line", "Long", "Pin", "Plum", "Pointer", "Ship", "Wind", "Arrow", "Mid Pin"};
    private DefaultValueDataset compassData = new DefaultValueDataset(new Double(0.0));
    private DefaultValueDataset shipData = new DefaultValueDataset(new Double(0.0));
    private CompassPlot compassPlot = new CompassPlot(this.compassData);
    private JFreeChart compassChart = new JFreeChart("Compass Test", JFreeChart.DEFAULT_TITLE_FONT, this.compassPlot, false);
    private ChartPanel panelCompass = new ChartPanel(this.compassChart);
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel panelCompassHolder = new JPanel();
    private BorderLayout borderLayout = new BorderLayout();
    private JPanel jPanel12 = new JPanel();
    private JCheckBox windNullCheckBox = new JCheckBox();
    private JCheckBox shipNullCheckBox = new JCheckBox();
    private Spinner spinWind = new Spinner(270);
    private Spinner spinShip = new Spinner(45);
    private JPanel jPanel1 = new JPanel();
    private JComboBox pick1Pointer = new JComboBox<String>(NEEDLE_TYPES);
    private JPanel jPanel2 = new JPanel();
    private JComboBox pick2Pointer = new JComboBox<String>(NEEDLE_TYPES);
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private TitledBorder titledBorder3;
    private GridLayout gridLayout2 = new GridLayout();

    public CompassDemo() {
        try {
            this.compassPlot.addData(this.shipData);
            this.compassPlot.setSeriesNeedle(0, 7);
            this.compassPlot.setSeriesNeedle(1, 5);
            this.compassPlot.setSeriesPaint(0, Color.blue);
            this.compassPlot.setSeriesOutlinePaint(0, Color.blue);
            this.compassPlot.setSeriesPaint(1, Color.red);
            this.compassPlot.setSeriesOutlinePaint(1, Color.red);
            this.pick1Pointer.setSelectedIndex(7);
            this.pick2Pointer.setSelectedIndex(5);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.titledBorder3 = new TitledBorder("");
        this.setLayout(this.gridLayout1);
        this.panelCompassHolder.setLayout(this.borderLayout);
        this.windNullCheckBox.setHorizontalTextPosition(10);
        this.windNullCheckBox.setText("Null");
        this.windNullCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompassDemo.this.checkWindNullActionPerformed(e);
            }
        });
        this.shipNullCheckBox.setHorizontalTextPosition(2);
        this.shipNullCheckBox.setText("Null");
        this.shipNullCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompassDemo.this.checkShipNullActionPerformed(e);
            }
        });
        this.spinShip.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("compassDemo:spinShipPropertyChange");
                Spinner spinner = (Spinner)evt.getSource();
                if (spinner.isEnabled()) {
                    CompassDemo.this.shipData.setValue(new Double(spinner.getValue()));
                }
            }
        });
        this.spinWind.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("compassDemo:spinWindPropertyChange");
                Spinner spinner = (Spinner)evt.getSource();
                if (spinner.isEnabled()) {
                    CompassDemo.this.compassData.setValue(new Double(spinner.getValue()));
                }
            }
        });
        this.jPanel12.setLayout(this.gridLayout2);
        this.jPanel2.setBorder(this.titledBorder1);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel1.setBorder(this.titledBorder2);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.titledBorder1.setTitle("Second Pointer");
        this.titledBorder2.setTitle("First Pointer");
        this.titledBorder3.setTitle("Plot Options");
        this.pick2Pointer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompassDemo.this.pick2PointerActionPerformed(e);
            }
        });
        this.pick1Pointer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompassDemo.this.pick1PointerActionPerformed(e);
            }
        });
        this.add((Component)this.panelCompassHolder, null);
        this.panelCompassHolder.add((Component)this.jPanel12, "South");
        this.jPanel12.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.pick1Pointer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.windNullCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.spinWind, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel12.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.pick2Pointer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.shipNullCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.spinShip, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelCompassHolder.add((Component)this.panelCompass, "Center");
    }

    public static void main(String[] args) {
        CompassDemo panel = new CompassDemo();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout(5, 5));
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Compass Demo");
        frame.getContentPane().add((Component)panel, "Center");
        frame.setSize(700, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    public void adjustData(double value) {
        Number val = this.compassData.getValue();
        double newVal = value;
        if (val != null) {
            newVal += val.doubleValue();
        }
        if (newVal > 360.0) {
            newVal = 0.0;
        }
        if (newVal < 0.0) {
            newVal = 360.0;
        }
        this.compassData.setValue(new Double(newVal));
    }

    void checkWindNullActionPerformed(ActionEvent e) {
        System.out.println("CompassDemo:checkWindNull: " + this.windNullCheckBox.isSelected());
        if (this.windNullCheckBox.isSelected()) {
            this.compassData.setValue(null);
            this.spinWind.setEnabled(false);
        } else {
            this.compassData.setValue(new Double(this.spinWind.getValue()));
            this.spinWind.setEnabled(true);
        }
        System.out.println("CompassDemo:checkWindNull: " + this.compassData.getValue());
    }

    void checkShipNullActionPerformed(ActionEvent e) {
        System.out.println("CompassDemo:checkShipNull: " + this.shipNullCheckBox.isSelected());
        if (this.shipNullCheckBox.isSelected()) {
            this.shipData.setValue(null);
            this.spinShip.setEnabled(false);
        } else {
            this.shipData.setValue(new Double(this.spinShip.getValue()));
            this.spinShip.setEnabled(true);
        }
    }

    void pick2PointerActionPerformed(ActionEvent e) {
        System.out.println("compassDemo:pick2PointActionPerformed " + e.getActionCommand() + ",");
        this.compassPlot.setSeriesNeedle(1, this.pick2Pointer.getSelectedIndex());
        this.compassPlot.setSeriesPaint(1, Color.red);
        this.compassPlot.setSeriesOutlinePaint(1, Color.red);
    }

    void pick1PointerActionPerformed(ActionEvent e) {
        System.out.println("compassDemo:pick1PointActionPerformed " + e.getActionCommand() + ",");
        this.compassPlot.setSeriesNeedle(0, this.pick1Pointer.getSelectedIndex());
        this.compassPlot.setSeriesPaint(0, Color.blue);
        this.compassPlot.setSeriesOutlinePaint(0, Color.blue);
    }
}

