/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CompassFormat;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYAreaRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CompassFormatDemo
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public CompassFormatDemo(String title) {
        super(title);
        JFreeChart chart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private XYDataset createDirectionDataset(int count) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("Wind Direction", clazz);
        RegularTimePeriod start = new Minute();
        double direction = 180.0;
        int i = 0;
        while (i < count) {
            s1.add(start, direction);
            start = ((RegularTimePeriod)start).next();
            direction += (Math.random() - 0.5) * 15.0;
            if (direction < 0.0) {
                direction += 360.0;
            } else if (direction > 360.0) {
                direction -= 360.0;
            }
            ++i;
        }
        dataset.addSeries(s1);
        return dataset;
    }

    private XYDataset createForceDataset(int count) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries s1 = new TimeSeries("Wind Force", clazz);
        RegularTimePeriod start = new Minute();
        double force = 3.0;
        int i = 0;
        while (i < count) {
            s1.add(start, force);
            start = ((RegularTimePeriod)start).next();
            force = Math.max(0.5, force + (Math.random() - 0.5) * 0.5);
            ++i;
        }
        dataset.addSeries(s1);
        return dataset;
    }

    private JFreeChart createChart() {
        XYDataset direction = this.createDirectionDataset(600);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Time", "Date", "Direction", direction, true, true, false);
        XYPlot plot = chart.getXYPlot();
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getDomainAxis().setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        TickUnits units = new TickUnits();
        units.add(new NumberTickUnit(180.0, new CompassFormat()));
        units.add(new NumberTickUnit(90.0, new CompassFormat()));
        units.add(new NumberTickUnit(45.0, new CompassFormat()));
        units.add(new NumberTickUnit(22.5, new CompassFormat()));
        rangeAxis.setStandardTickUnits(units);
        plot.setRangeAxis(rangeAxis);
        XYAreaRenderer renderer2 = new XYAreaRenderer();
        NumberAxis axis2 = new NumberAxis("Force");
        axis2.setRange(0.0, 12.0);
        renderer2.setSeriesPaint(0, new Color(0, 0, 255, 128));
        plot.setDataset(1, this.createForceDataset(600));
        plot.setRenderer(1, renderer2);
        plot.setRangeAxis(1, axis2);
        plot.mapDatasetToRangeAxis(1, 1);
        return chart;
    }

    public static void main(String[] args) {
        CompassFormatDemo demo = new CompassFormatDemo("Compass Format Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

