/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.util.Date;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.data.ContourDataset;
import org.jfree.data.DefaultContourDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ContourPlotDemo
extends ApplicationFrame {
    private ValueAxis xAxis = null;
    private NumberAxis yAxis = null;
    private ColorBar zColorBar = null;
    private static boolean xIsDate = false;
    private static boolean xIsLog = false;
    private static boolean yIsLog = false;
    private static boolean zIsLog = false;
    private static boolean xIsInverted = false;
    private static boolean yIsInverted = false;
    private static boolean zIsInverted = false;
    private static boolean makeHoles = false;
    private static int numX = 10;
    private static int numY = 20;
    private static double ratio = 0.0;
    public ChartPanel panel = null;

    public ContourPlotDemo(String title) {
        super(title);
        JFreeChart chart = this.createContourPlot();
        this.panel = new ChartPanel(chart, true, true, true, true, true);
        this.panel.setPreferredSize(new Dimension(500, 270));
        this.panel.setMaximumDrawHeight(100000);
        this.panel.setMaximumDrawWidth(100000);
        this.panel.setHorizontalZoom(true);
        this.panel.setVerticalZoom(true);
        this.panel.setFillZoomRectangle(true);
    }

    private JFreeChart createContourPlot() {
        String title = "Contour Plot";
        String xAxisLabel = "X Values";
        String yAxisLabel = "Y Values";
        String zAxisLabel = "Color Values";
        if (xIsDate) {
            this.xAxis = new DateAxis("X Values");
            xIsLog = false;
        } else {
            this.xAxis = xIsLog ? new LogarithmicAxis("X Values") : new NumberAxis("X Values");
        }
        this.yAxis = yIsLog ? new LogarithmicAxis("Y Values") : new NumberAxis("Y Values");
        this.zColorBar = zIsLog ? new ColorBar("Color Values") : new ColorBar("Color Values");
        if (this.xAxis instanceof NumberAxis) {
            ((NumberAxis)this.xAxis).setAutoRangeIncludesZero(false);
            ((NumberAxis)this.xAxis).setInverted(xIsInverted);
        }
        this.yAxis.setAutoRangeIncludesZero(false);
        this.yAxis.setInverted(yIsInverted);
        if (!xIsDate) {
            ((NumberAxis)this.xAxis).setLowerMargin(0.0);
            ((NumberAxis)this.xAxis).setUpperMargin(0.0);
        }
        this.yAxis.setLowerMargin(0.0);
        this.yAxis.setUpperMargin(0.0);
        this.zColorBar.getAxis().setInverted(zIsInverted);
        this.zColorBar.getAxis().setTickMarksVisible(true);
        ContourDataset data = this.createDataset();
        ContourPlot plot = new ContourPlot(data, this.xAxis, this.yAxis, this.zColorBar);
        if (xIsDate) {
            ratio = Math.abs(ratio);
        }
        plot.setDataAreaRatio(ratio);
        JFreeChart chart = new JFreeChart("Contour Plot", null, plot, false);
        chart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return chart;
    }

    private ContourDataset createDataset() {
        int numValues = numX * numY;
        Object[] tmpDateX = new Date[numValues];
        double[] tmpDoubleX = new double[numValues];
        double[] tmpDoubleY = new double[numValues];
        Object[] oDoubleX = new Double[numValues];
        Object[] oDoubleY = new Double[numValues];
        Object[] oDoubleZ = new Double[numValues];
        int j = 0;
        int z = 0;
        int i = 0;
        int last = 0;
        double zmult = 1.0;
        int k = 0;
        while (k < numValues) {
            i = k / numX;
            if (last != i) {
                last = i;
                z = 0;
                zmult *= 1.005;
            }
            tmpDateX[k] = new Date((long)((double)(i + 100) * 1.0E8));
            tmpDoubleX[k] = i + 2;
            tmpDoubleY[k] = zmult * (double)z++;
            oDoubleX[k] = new Double(tmpDoubleX[k]);
            oDoubleY[k] = new Double(tmpDoubleY[k]);
            double rad = Math.random();
            oDoubleZ[k] = makeHoles && rad > 0.4 && rad < 0.6 ? null : new Double(3.0 * ((tmpDoubleX[k] + 1.0) * (tmpDoubleY[k] + 1.0) + 100.0));
            ++j;
            ++k;
        }
        DefaultContourDataset data = null;
        data = xIsDate ? new DefaultContourDataset("Contouring", tmpDateX, oDoubleY, oDoubleZ) : new DefaultContourDataset("Contouring", oDoubleX, oDoubleY, oDoubleZ);
        return data;
    }

    protected static boolean processArgs(String[] args) {
        String[] options = new String[]{"-?", "-invert", "-log", "-date", "-vertical", "-holes", "-ratio:", "-numX:", "-numY:"};
        int i = 0;
        while (i < args.length) {
            boolean foundOption = false;
            int j = 0;
            while (j < options.length) {
                if (args[i].startsWith(options[j])) {
                    foundOption = true;
                    int index = 0;
                    String tmpStr = null;
                    switch (j) {
                        case 0: {
                            ContourPlotDemo.usage();
                            return false;
                        }
                        case 1: {
                            xIsInverted = true;
                            yIsInverted = true;
                            zIsInverted = true;
                            break;
                        }
                        case 2: {
                            xIsLog = true;
                            yIsLog = true;
                            zIsLog = true;
                            break;
                        }
                        case 3: {
                            xIsDate = true;
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            makeHoles = true;
                            break;
                        }
                        case 6: {
                            index = args[i].indexOf(58);
                            tmpStr = args[i].substring(index + 1);
                            ratio = Double.parseDouble(tmpStr);
                            break;
                        }
                        case 7: {
                            index = args[i].indexOf(58);
                            tmpStr = args[i].substring(index + 1);
                            numX = Integer.parseInt(tmpStr);
                            break;
                        }
                        case 8: {
                            index = args[i].indexOf(58);
                            tmpStr = args[i].substring(index + 1);
                            numY = Integer.parseInt(tmpStr);
                            break;
                        }
                        default: {
                            System.out.println("Only 9 options available, update options array");
                        }
                    }
                }
                ++j;
            }
            if (!foundOption) {
                System.out.println("Unknown option: " + args[i]);
                ContourPlotDemo.usage();
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("ContourPlotDemo -? -invert -log -date -vertical -holes -ratio:value -numX:value -numY:value");
        System.out.println("Where:");
        System.out.println("-? displays usage and exits");
        System.out.println("-invert cause axes to be inverted");
        System.out.println("-log all axes will be logcale");
        System.out.println("-date the X axis will be a date");
        System.out.println("-vertical the colorbar will be drawn vertically");
        System.out.println("-holes demos plotting data with missing values");
        System.out.println("-ratio forces plot to maintain aspect ratio (Y/X) indicated by value");
        System.out.println("       positive values are in pixels, while negative is in plot units");
        System.out.println("-numX number of values to generate along the X axis");
        System.out.println("-numY number of values to generate along the X axis");
    }

    public static void main(String[] args) {
        if (!ContourPlotDemo.processArgs(args)) {
            System.exit(1);
        }
        ContourPlotDemo demo = new ContourPlotDemo("ContourPlot Demo");
        demo.setContentPane(demo.panel);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

