/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.CyclicXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CyclicXYPlotDemo
extends ApplicationFrame
implements ActionListener {
    XYSeries series = new XYSeries("Random Data");
    long x = 0L;
    double y = 50.0;
    Timer timer;

    public CyclicXYPlotDemo(String title) {
        super(title);
        this.series.setMaximumItemCount(50);
        XYSeriesCollection data = new XYSeriesCollection(this.series);
        JFreeChart chart = ChartFactory.createXYLineChart("Cyclic XY Plot Demo", "X", "Y", data, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = chart.getXYPlot();
        plot.setDomainAxis(new CyclicNumberAxis(10.0, 0.0));
        plot.setRenderer(new CyclicXYItemRenderer());
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setAutoRangeIncludesZero(false);
        axis.setAutoRangeMinimumSize(1.0);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(400, 300));
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)chartPanel, "Center");
        JButton button1 = new JButton("Start");
        button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CyclicXYPlotDemo.this.timer.start();
            }
        });
        JButton button2 = new JButton("Stop");
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CyclicXYPlotDemo.this.timer.stop();
            }
        });
        JButton button3 = new JButton("Step by step");
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CyclicXYPlotDemo.this.actionPerformed(null);
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(button1);
        buttonPanel.add(button2);
        buttonPanel.add(button3);
        content.add((Component)buttonPanel, "South");
        this.setContentPane(content);
        this.timer = new Timer(200, this);
    }

    public static void main(String[] args) {
        CyclicXYPlotDemo demo = new CyclicXYPlotDemo("Cyclic XY Plot Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        double delta = Math.random() * 10.0 - 5.0;
        if (delta == -5.0) {
            delta = 0.0;
        }
        this.y += delta;
        this.series.add((double)this.x++ / 4.0, this.y);
    }
}

