/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DualAxisDemo3
extends ApplicationFrame {
    public DualAxisDemo3(String title) {
        super(title);
        CategoryDataset dataset1 = this.createDataset1();
        JFreeChart chart = ChartFactory.createBarChart("Dual Axis Chart", "Category", "Value", dataset1, PlotOrientation.HORIZONTAL, true, true, false);
        chart.setBackgroundPaint(new Color(204, 255, 204));
        chart.getLegend().setAnchor(0);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.getDomainAxis().setMaxCategoryLabelWidthRatio(10.0f);
        CategoryDataset dataset2 = this.createDataset2();
        NumberAxis axis2 = new NumberAxis("Secondary");
        plot.setRangeAxis(1, axis2);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        LineAndShapeRenderer renderer2 = new LineAndShapeRenderer();
        plot.setRenderer(1, renderer2);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset1() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        String category6 = "Category 6";
        String category7 = "Category 7";
        String category8 = "Category 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        dataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        dataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 6"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 7"));
        dataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 8"));
        dataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        dataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        dataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        dataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 6"));
        dataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 7"));
        dataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 8"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        dataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 6"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 7"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 8"));
        return dataset;
    }

    private CategoryDataset createDataset2() {
        String series1 = "Fourth";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        String category6 = "Category 6";
        String category7 = "Category 7";
        String category8 = "Category 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(15.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 1"));
        dataset.addValue(24.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 2"));
        dataset.addValue(31.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 3"));
        dataset.addValue(25.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 4"));
        dataset.addValue(56.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 5"));
        dataset.addValue(37.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 6"));
        dataset.addValue(77.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 7"));
        dataset.addValue(18.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 8"));
        return dataset;
    }

    public static void main(String[] args) {
        DualAxisDemo3 demo = new DualAxisDemo3("Dual Axis Demo 3");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

