/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DualAxisDemo5
extends ApplicationFrame {
    public DualAxisDemo5(String title) {
        super(title);
        CategoryDataset dataset1 = this.createDataset1();
        CategoryDataset dataset2 = this.createDataset2();
        JFreeChart chart = this.createChart(dataset1, dataset2);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset1() {
        String series1 = "Series 1";
        String series2 = "Dummy 1";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        dataset.addValue(4.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        dataset.addValue(3.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 3"));
        dataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 4"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 1"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 2"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 3"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 4"));
        return dataset;
    }

    private CategoryDataset createDataset2() {
        String series1 = "Dummy 2";
        String series2 = "Series 2";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 1"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 2"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 3"));
        dataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 4"));
        dataset.addValue(75.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
        dataset.addValue(87.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
        dataset.addValue(96.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 3"));
        dataset.addValue(68.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 4"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset1, CategoryDataset dataset2) {
        CategoryAxis domainAxis = new CategoryAxis("Category");
        NumberAxis rangeAxis = new NumberAxis("Value");
        BarRenderer renderer1 = new BarRenderer();
        CategoryPlot plot = new CategoryPlot(dataset1, domainAxis, rangeAxis, renderer1){

            public LegendItemCollection getLegendItems() {
                CategoryItemRenderer renderer2;
                CategoryDataset dset2;
                CategoryItemRenderer r;
                LegendItemCollection result = new LegendItemCollection();
                CategoryDataset data = this.getDataset();
                if (data != null && (r = this.getRenderer()) != null) {
                    LegendItem item = r.getLegendItem(0, 0);
                    result.add(item);
                }
                if ((dset2 = this.getDataset(1)) != null && (renderer2 = this.getRenderer(1)) != null) {
                    LegendItem item = renderer2.getLegendItem(1, 1);
                    result.add(item);
                }
                return result;
            }
        };
        JFreeChart chart = new JFreeChart("Dual Axis Bar Chart", plot);
        chart.setBackgroundPaint(Color.white);
        chart.getLegend().setAnchor(3);
        plot.setBackgroundPaint(new Color(238, 238, 255));
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        plot.setDataset(1, dataset2);
        plot.mapDatasetToRangeAxis(1, 1);
        NumberAxis axis2 = new NumberAxis("Secondary");
        plot.setRangeAxis(1, axis2);
        plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        BarRenderer renderer2 = new BarRenderer();
        plot.setRenderer(1, renderer2);
        return chart;
    }

    public static void main(String[] args) {
        DualAxisDemo5 demo = new DualAxisDemo5("Dual Axis Demo 5");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

