/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.DefaultXYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.Spacer;

public class DynamicDataDemo2
extends ApplicationFrame
implements ActionListener {
    private TimeSeries series1;
    private TimeSeries series2;
    private double lastValue1 = 100.0;
    private double lastValue2 = 500.0;
    static /* synthetic */ Class class$0;

    public DynamicDataDemo2(String title) {
        super(title);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Millisecond");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.series1 = new TimeSeries("Random 1", clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.jfree.data.time.Millisecond");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.series2 = new TimeSeries("Random 2", clazz2);
        TimeSeriesCollection dataset1 = new TimeSeriesCollection(this.series1);
        TimeSeriesCollection dataset2 = new TimeSeriesCollection(this.series2);
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Dynamic Data Demo 2", "Time", "Value", dataset1, true, true, false);
        chart.setBackgroundPaint(Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 4.0, 4.0, 4.0, 4.0));
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setFixedAutoRange(60000.0);
        plot.setDataset(1, dataset2);
        NumberAxis rangeAxis2 = new NumberAxis("Range Axis 2");
        rangeAxis2.setAutoRangeIncludesZero(false);
        plot.setRenderer(1, new DefaultXYItemRenderer());
        plot.setRangeAxis(1, rangeAxis2);
        plot.mapDatasetToRangeAxis(1, 1);
        JPanel content = new JPanel(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(chart);
        content.add(chartPanel);
        JButton button1 = new JButton("Add To Series 1");
        button1.setActionCommand("ADD_DATA_1");
        button1.addActionListener(this);
        JButton button2 = new JButton("Add To Series 2");
        button2.setActionCommand("ADD_DATA_2");
        button2.addActionListener(this);
        JButton button3 = new JButton("Add To Both");
        button3.setActionCommand("ADD_BOTH");
        button3.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(button1);
        buttonPanel.add(button2);
        buttonPanel.add(button3);
        content.add((Component)buttonPanel, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(content);
    }

    public void actionPerformed(ActionEvent e) {
        Millisecond now;
        double factor;
        boolean add1 = false;
        boolean add2 = false;
        if (e.getActionCommand().equals("ADD_DATA_1")) {
            add1 = true;
        } else if (e.getActionCommand().equals("ADD_DATA_2")) {
            add2 = true;
        } else if (e.getActionCommand().equals("ADD_BOTH")) {
            add1 = true;
            add2 = true;
        }
        if (add1) {
            factor = 0.9 + 0.2 * Math.random();
            this.lastValue1 *= factor;
            now = new Millisecond();
            System.out.println("Now = " + now.toString());
            this.series1.add((RegularTimePeriod)new Millisecond(), this.lastValue1);
        }
        if (add2) {
            factor = 0.9 + 0.2 * Math.random();
            this.lastValue2 *= factor;
            now = new Millisecond();
            System.out.println("Now = " + now.toString());
            this.series2.add((RegularTimePeriod)new Millisecond(), this.lastValue2);
        }
    }

    public static void main(String[] args) {
        DynamicDataDemo2 demo = new DynamicDataDemo2("Dynamic Data Demo 2");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

